/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.setup;

import dev.su5ed.mffs.api.module.InterdictionMatrixModule;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.util.module.AntiPersonnelModule;
import dev.su5ed.mffs.util.module.BaseInterdictionModule;
import dev.su5ed.mffs.util.module.BaseModule;
import dev.su5ed.mffs.util.module.ConfiscationModule;
import dev.su5ed.mffs.util.module.DisintegrationModule;
import dev.su5ed.mffs.util.module.DomeModule;
import dev.su5ed.mffs.util.module.ExterminatingModule;
import dev.su5ed.mffs.util.module.FusionModule;
import dev.su5ed.mffs.util.module.ShockModule;
import dev.su5ed.mffs.util.module.SpongeModule;
import dev.su5ed.mffs.util.module.StabilizationModule;
import dev.su5ed.mffs.util.module.WarnModule;
import java.util.Set;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public final class ModModules {
    public static final ModuleType<Module> FUSION = ModModules.create(FusionModule::new, 1.0f);
    public static final ModuleType<Module> SHOCK = ModModules.create(ShockModule::new, 1.0f);
    public static final ModuleType<Module> SPEED = ModModules.create(1.0f);
    public static final ModuleType<Module> CAMOUFLAGE = ModModules.create(1.5f);
    public static final ModuleType<Module> SCALE = ModModules.create(1.2f, Module.Category.FIELD, Module.Category.INTERDICTION);
    public static final ModuleType<Module> CAPACITY = ModModules.create(Module.Category.MATRIX);
    public static final ModuleType<Module> DISINTEGRATION = ModModules.create(DisintegrationModule::new, 20.0f);
    public static final ModuleType<Module> TRANSLATION = ModModules.create(1.6f, Module.Category.FIELD);
    public static final ModuleType<Module> ROTATION = ModModules.create(0.1f, Module.Category.FIELD);
    public static final ModuleType<Module> GLOW = ModModules.create(Module.Category.MATRIX);
    public static final ModuleType<Module> SILENCE = ModModules.create(1.0f);
    public static final ModuleType<Module> SPONGE = ModModules.create(SpongeModule::new, 1.0f);
    public static final ModuleType<Module> DOME = ModModules.create(DomeModule::new, 0.5f, Module.Category.MATRIX);
    public static final ModuleType<Module> COLLECTION = ModModules.create(15.0f);
    public static final ModuleType<Module> STABILIZAZION = ModModules.create(StabilizationModule::new, 20.0f);
    public static final ModuleType<Module> INVERTER = ModModules.create(15.0f);
    public static final ModuleType<InterdictionMatrixModule> WARN = ModModules.createInterdiction(WarnModule::new);
    public static final ModuleType<InterdictionMatrixModule> BLOCK_ACCESS = ModModules.createInterdiction(10.0f);
    public static final ModuleType<InterdictionMatrixModule> BLOCK_ALTER = ModModules.createInterdiction(15.0f);
    public static final ModuleType<InterdictionMatrixModule> ANTI_FRIENDLY = ModModules.createInterdiction((type, stack) -> new ExterminatingModule(type, stack, target -> target instanceof Mob && target.getType().getCategory().isFriendly()));
    public static final ModuleType<InterdictionMatrixModule> ANTI_HOSTILE = ModModules.createInterdiction((type, stack) -> new ExterminatingModule(type, stack, target -> target instanceof Mob && !target.getType().getCategory().isFriendly()));
    public static final ModuleType<InterdictionMatrixModule> ANTI_PERSONNEL = ModModules.createInterdiction(AntiPersonnelModule::new);
    public static final ModuleType<InterdictionMatrixModule> ANTI_SPAWN = ModModules.createInterdiction(10.0f);
    public static final ModuleType<InterdictionMatrixModule> CONFISCATION = ModModules.createInterdiction(ConfiscationModule::new);

    private ModModules() {
    }

    private static ModuleType<Module> create(ModuleFactory<Module> factory, float fortronCost) {
        return new BaseModuleType<Module>(factory, fortronCost, Module.Category.MATRIX);
    }

    private static ModuleType<Module> create(Module.Category ... categories) {
        return ModModules.create(BaseModule::new, 0.5f, categories);
    }

    private static ModuleType<Module> create(float fortronCost, Module.Category ... categories) {
        return ModModules.create(BaseModule::new, fortronCost, categories);
    }

    private static ModuleType<Module> create(ModuleFactory<Module> factory, float fortronCost, Module.Category ... categories) {
        return new BaseModuleType<Module>(factory, fortronCost, categories);
    }

    private static ModuleType<Module> create(float fortronCost) {
        return new BaseModuleType<Module>(BaseModule::new, fortronCost, new Module.Category[0]);
    }

    private static ModuleType<InterdictionMatrixModule> createInterdiction(float fortronCost) {
        return ModModules.createInterdiction(BaseInterdictionModule::new, fortronCost);
    }

    private static ModuleType<InterdictionMatrixModule> createInterdiction(ModuleFactory<InterdictionMatrixModule> factory) {
        return ModModules.createInterdiction(factory, 0.5f);
    }

    private static ModuleType<InterdictionMatrixModule> createInterdiction(ModuleFactory<InterdictionMatrixModule> factory, float fortronCost) {
        return new BaseModuleType<InterdictionMatrixModule>(factory, fortronCost, Module.Category.INTERDICTION);
    }

    public static class BaseModuleType<T extends Module>
    implements ModuleType<T> {
        private final float fortronCost;
        private final Set<Module.Category> categories;
        private final ModuleFactory<T> factory;

        public BaseModuleType(ModuleFactory<T> factory, float fortronCost, Module.Category ... categories) {
            this.factory = factory;
            this.fortronCost = fortronCost;
            this.categories = Set.of(categories);
        }

        @Override
        public float getFortronCost(float amplifier) {
            return this.fortronCost;
        }

        @Override
        public Set<Module.Category> getCategories() {
            return this.categories;
        }

        @Override
        public T createModule(ItemStack stack) {
            return this.factory.create(this, stack);
        }
    }

    public static interface ModuleFactory<T extends Module> {
        public T create(ModuleType<T> var1, ItemStack var2);
    }
}

