/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class BaseButton
extends AbstractButton {
    private final Runnable onPress;

    public BaseButton(int x, int y, int width, int height, Runnable onPress) {
        super(x, y, width, height, (Component)Component.empty());
        this.onPress = onPress;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        ResourceLocation widgetsLocation = SPRITES.get(this.active, this.isHovered());
        guiGraphics.blitSprite(widgetsLocation, this.getX(), this.getY(), this.width, this.height);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderFg(guiGraphics, minecraft, mouseX, mouseY, partialTick);
    }

    protected abstract void renderFg(GuiGraphics var1, Minecraft var2, int var3, int var4, float var5);

    public void onPress() {
        this.onPress.run();
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }
}

