/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import java.util.Optional;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;

public class VoidUpgradeItem
extends UpgradeItem {
    public VoidUpgradeItem(Item.Properties pProperties) {
        super(pProperties, "void_upgrade");
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.enableUpgrade.get() != false && super.isEnabled(enabledFeatures);
    }

    @Override
    public boolean requiresEquippedBackpack() {
        return false;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return VoidUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = (BackpackContainerContents)provider.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(9));
            filter = filter.updateSlot(new BackpackContainerContents.Slot(0, ItemStack.EMPTY.copy()));
            return Optional.of(new VoidUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, filter.getItems()));
        };
    }
}

