/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class AutoPickupUpgrade
extends UpgradeBase<AutoPickupUpgrade>
implements IFilter,
IEnable {
    public ItemStackHandler filter;
    private final AutoPickupFilterSettings filterSettings;

    public AutoPickupUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.filterSlotCount.get();
        this.filterSettings = new AutoPickupFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.isEmpty()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().getOrDefault(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    }

    public AutoPickupFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean canPickup(ItemStack stack) {
        return this.getFilterSettings().matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public int getFilterSlotCount() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.filterSlotCount.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AutoPickupWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.filterSlotCount.get();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean isActive() {
                        return super.isActive() && AutoPickupUpgrade.this.getFilter().get(0) != 2;
                    }

                    @Override
                    public boolean mayPlace(ItemStack pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.mayPlace(pStack);
                    }
                });
            }
        }
        return slots;
    }

    private ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                AutoPickupUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(9, AutoPickupUpgrade.this.filter));
                AutoPickupUpgrade.this.getFilterSettings().updateFilter((List<ItemStack>)((BackpackContainerContents)AutoPickupUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

