/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.filter;

import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.filter.FilterBehavior;
import it.zerono.mods.zerocore.lib.item.inventory.filter.FilterManager;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilter;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterCondition;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class Filter
implements IFilter {
    private final Map<String, IFilterCondition> _conditions = Maps.newHashMap();
    private FilterBehavior _behavior = FilterBehavior.BlackList;
    private EnumSet<ItemHelper.MatchOption> _matchOptions = ItemHelper.MatchOption.MATCH_ALWAYS;
    private static final String NBT_BEHAVIOR_KEY = "Behavior";
    private static final String NBT_OPTIONS_KEY = "Options";
    private static final String NBT_CONDITIONS_KEY = "Conditions";

    @Override
    public boolean canAccept(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (IFilterCondition condition : this._conditions.values()) {
            if (!condition.match(stack, this.getMatchOptions())) continue;
            return FilterBehavior.WhiteList == this.getBehavior();
        }
        return FilterBehavior.BlackList == this.getBehavior();
    }

    @Override
    public Optional<IFilterCondition> getCondition(String name) {
        return Optional.ofNullable(this._conditions.get(name));
    }

    @Override
    public void addCondition(String name, IFilterCondition condition) {
        this._conditions.put(name, condition);
    }

    @Override
    public void removeCondition(String name) {
        this._conditions.remove(name);
    }

    @Override
    public FilterBehavior getBehavior() {
        return this._behavior;
    }

    @Override
    public void setBehavior(FilterBehavior behavior) {
        this._behavior = behavior;
    }

    @Override
    public EnumSet<ItemHelper.MatchOption> getMatchOptions() {
        return this._matchOptions;
    }

    @Override
    public void setMatchOptions(EnumSet<ItemHelper.MatchOption> options) {
        this._matchOptions = options;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag conditionsList = new ListTag();
        this._conditions.forEach((name, condition) -> {
            CompoundTag nameTag = new CompoundTag();
            nameTag.putString("name", name);
            conditionsList.add((Object)nameTag);
            conditionsList.add((Object)FilterManager.getInstance().storeComponentToNBT(provider, (IFilterCondition)condition));
        });
        nbt.put(NBT_CONDITIONS_KEY, (Tag)conditionsList);
        NBTHelper.nbtSetEnum(nbt, NBT_BEHAVIOR_KEY, this._behavior);
        NBTHelper.nbtSetEnumSet(nbt, NBT_OPTIONS_KEY, this._matchOptions);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains(NBT_CONDITIONS_KEY)) {
            ListTag conditionsList = nbt.getList(NBT_CONDITIONS_KEY, 10);
            this._conditions.clear();
            for (int i = 0; i < conditionsList.size(); i += 2) {
                CompoundTag nameTag = conditionsList.getCompound(i);
                if (!nameTag.contains("name") || i + 1 >= conditionsList.size()) continue;
                Optional<IFilterCondition> condition = FilterManager.getInstance().loadComponentFromNBT(provider, conditionsList.getCompound(i + 1));
                condition.ifPresent(c -> this._conditions.put(nameTag.getString("name"), (IFilterCondition)c));
            }
        }
        if (nbt.contains(NBT_BEHAVIOR_KEY)) {
            this._behavior = NBTHelper.nbtGetEnum(nbt, NBT_BEHAVIOR_KEY, FilterBehavior.class);
        }
        if (nbt.contains(NBT_OPTIONS_KEY)) {
            this._matchOptions = NBTHelper.nbtGetEnumSet(nbt, NBT_OPTIONS_KEY, ItemHelper.MatchOption.class);
        }
    }
}

