/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.internal.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public final class NBTHelper {
    public static final CompoundTag EMPTY_COMPOUND = new CompoundTag();

    public static Optional<CompoundTag> nbtFrom(File file, NbtAccounter accounter) {
        if (file.exists()) {
            Optional<CompoundTag> optional;
            FileInputStream stream = new FileInputStream(file);
            try {
                optional = Optional.of(NbtIo.readCompressed((InputStream)stream, (NbtAccounter)accounter));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    Log.LOGGER.error(Log.CORE, "Error while reading compressed NBT file.", (Throwable)ex);
                }
            }
            stream.close();
            return optional;
        }
        return Optional.empty();
    }

    public static boolean nbtTo(File file, CompoundTag data) {
        boolean bl;
        FileOutputStream stream = new FileOutputStream(file);
        try {
            NbtIo.writeCompressed((CompoundTag)data, (OutputStream)stream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                Log.LOGGER.error(Log.CORE, "Error while writing compressed NBT file.", (Throwable)ex);
                return false;
            }
        }
        stream.close();
        return bl;
    }

    public static <E extends Enum<E>> CompoundTag nbtSetEnum(CompoundTag nbt, String key, E value) {
        nbt.putString(key, value.name());
        return nbt;
    }

    public static <E extends Enum<E>> E nbtGetEnum(CompoundTag nbt, String key, Class<E> enumClass) throws IllegalArgumentException {
        return Enum.valueOf(enumClass, nbt.getString(key));
    }

    public static boolean nbtContainsEnum(CompoundTag nbt, String key) {
        return nbt.contains(key, 8);
    }

    public static <E extends Enum<E>> E nbtGetEnum(CompoundTag nbt, String key, Function<String, E> enumFactory, E defaultValue) {
        String value;
        if (nbt.contains(key) && !Strings.isNullOrEmpty((String)(value = nbt.getString(key)))) {
            return (E)((Enum)enumFactory.apply(value));
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> CompoundTag nbtSetEnumSet(CompoundTag nbt, String key, EnumSet<E> value) {
        ListTag tagList = new ListTag();
        for (Enum enumValue : value) {
            tagList.add((Object)NBTHelper.nbtSetEnum(new CompoundTag(), "enum", enumValue));
        }
        nbt.put(key, (Tag)tagList);
        return nbt;
    }

    public static boolean nbtContainsEnumSet(CompoundTag nbt, String key) {
        return nbt.contains(key, 9);
    }

    public static <E extends Enum<E>> EnumSet<E> nbtGetEnumSet(CompoundTag nbt, String key, Class<E> enumClass) throws IllegalArgumentException {
        ListTag tagList = nbt.getList(key, 8);
        ArrayList valueList = Lists.newArrayList();
        for (int i = 0; i < tagList.size(); ++i) {
            E enumValue = NBTHelper.nbtGetEnum(tagList.getCompound(i), "enum", enumClass);
            valueList.add(enumValue);
        }
        return EnumSet.copyOf(valueList);
    }

    private NBTHelper() {
    }
}

