/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.fluid;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.IOPortBlockCapabilitySource;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.AbstractFluidPortHandler;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import java.util.function.Function;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidPortHandlerForge<Controller extends AbstractCuboidMultiblockController<Controller>, Port extends AbstractMultiblockEntity<Controller>>
extends AbstractFluidPortHandler<Controller, Port>
implements IFluidHandler {
    private final FluidHandlerForwarder _capabilityForwarder = new FluidHandlerForwarder((IFluidHandler)EmptyFluidHandler.INSTANCE);
    private final IOPortBlockCapabilitySource<Controller, Port, IFluidHandler> _remoteCapabilitySource;

    public FluidPortHandlerForge(Port port, IoMode mode) {
        super(port, mode);
        this._remoteCapabilitySource = new IOPortBlockCapabilitySource(port, Capabilities.FluidHandler.BLOCK);
    }

    @Override
    public boolean isConnected() {
        return null != this._remoteCapabilitySource.getCapability();
    }

    @Override
    public void onPortChanged() {
        this._remoteCapabilitySource.onPortChanged();
    }

    @Override
    public int outputFluid(FluidStack stack) {
        IFluidHandler consumer = (IFluidHandler)this._remoteCapabilitySource.getCapability();
        if (null == consumer || this.isPassive() || ((IIoEntity)this.getIoEntity()).getIoDirection().isInput()) {
            return 0;
        }
        return consumer.fill(stack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public int inputFluid(IFluidHandler destination, int maxAmount) {
        IFluidHandler consumer = (IFluidHandler)this._remoteCapabilitySource.getCapability();
        if (null == consumer || this.isPassive() || ((IIoEntity)this.getIoEntity()).getIoDirection().isOutput()) {
            return 0;
        }
        FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)consumer, (int)maxAmount, (boolean)true);
        return transferred.isEmpty() ? 0 : transferred.getAmount();
    }

    @Override
    public void update(Function<@NotNull IoDirection, @NotNull IFluidHandler> handlerProvider) {
        this._capabilityForwarder.setHandler(handlerProvider.apply(((IIoEntity)this.getIoEntity()).getIoDirection()));
    }

    public int getTanks() {
        return this._capabilityForwarder.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this._capabilityForwarder.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this._capabilityForwarder.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this._capabilityForwarder.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.fill(resource, action) : 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.drain(resource, action) : FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.isPassive() ? this._capabilityForwarder.drain(maxDrain, action) : FluidStack.EMPTY;
    }
}

