/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class LamppostDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean leftRoadSide;
    private Records.WoodAssets wood;

    public LamppostDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, boolean leftRoadSide) {
        super(pos, direction, world);
        this.leftRoadSide = leftRoadSide;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.leftRoadSide);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        world.setBlock(basePos.above(2).relative(props.offsetDirection.getOpposite()), (BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(true)), 3);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(BlockPos pos, OrientedDecoration.DirectionProperties props) {
        WorldGenLevel world = this.getWorld();
        world.setBlock(pos.above(3).relative(props.offsetDirection.getOpposite()), (BlockState)this.wood.fence().defaultBlockState().setValue(props.directionProperty, (Comparable)Boolean.valueOf(true)), 3);
        world.setBlock(pos.above(0), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(1), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(2), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(3), (BlockState)this.wood.fence().defaultBlockState().setValue(props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)), 3);
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

