/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.events;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.RoadFeature;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.Road;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModEventHandler {
    private static final int THREAD_COUNT = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    private static ExecutorService executor = Executors.newFixedThreadPool(7);
    private static final ConcurrentHashMap<String, Future<?>> runningTasks = new ConcurrentHashMap();

    public static void register() {
        ServerWorldEvents.LOAD.register((server, serverWorld) -> {
            ModEventHandler.restartExecutorIfNeeded();
            if (!serverWorld.dimension().equals(Level.OVERWORLD)) {
                return;
            }
            Records.StructureLocationData structureLocationData = (Records.StructureLocationData)serverWorld.getAttachedOrCreate(WorldDataAttachment.STRUCTURE_LOCATIONS, () -> new Records.StructureLocationData(new ArrayList<BlockPos>()));
            if (structureLocationData.structureLocations().size() < ModConfig.initialLocatingCount) {
                for (int i = 0; i < ModConfig.initialLocatingCount; ++i) {
                    StructureConnector.cacheNewConnection(serverWorld, false);
                    ModEventHandler.tryGenerateNewRoads(serverWorld, true, 5000);
                }
            }
        });
        ServerWorldEvents.UNLOAD.register((server, serverWorld) -> {
            if (!serverWorld.dimension().equals(Level.OVERWORLD)) {
                return;
            }
            Future<?> task = runningTasks.remove(serverWorld.dimension().location().toString());
            if (task != null && !task.isDone()) {
                task.cancel(true);
                LOGGER.debug("Aborted running road task for world: {}", (Object)serverWorld.dimension().location());
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(serverWorld -> {
            if (!serverWorld.dimension().equals(Level.OVERWORLD)) {
                return;
            }
            ModEventHandler.tryGenerateNewRoads(serverWorld, true, 5000);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            RoadPathCalculator.heightCache.clear();
            runningTasks.values().forEach(future -> future.cancel(true));
            runningTasks.clear();
            executor.shutdownNow();
            LOGGER.debug("SettlementRoads: ExecutorService shut down.");
        });
    }

    private static void tryGenerateNewRoads(ServerLevel serverWorld, Boolean async, int steps) {
        if (!StructureConnector.cachedStructureConnections.isEmpty()) {
            FeatureConfiguration featureConfiguration;
            Records.StructureConnection structureConnection = StructureConnector.cachedStructureConnections.poll();
            ConfiguredFeature feature = (ConfiguredFeature)serverWorld.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).get(RoadFeature.ROAD_FEATURE_KEY);
            if (feature != null && (featureConfiguration = feature.config()) instanceof RoadFeatureConfig) {
                RoadFeatureConfig roadConfig = (RoadFeatureConfig)featureConfiguration;
                if (async.booleanValue()) {
                    Future<?> future = executor.submit(() -> {
                        try {
                            new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error generating road", (Throwable)e);
                        }
                    });
                    runningTasks.put(serverWorld.dimension().location().toString(), future);
                } else {
                    new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
                }
            }
        }
    }

    private static void restartExecutorIfNeeded() {
        if (executor.isShutdown() || executor.isTerminated()) {
            executor = Executors.newFixedThreadPool(7);
            LOGGER.debug("SettlementRoads: ExecutorService restarted.");
        }
    }
}

