/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.grid;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.grid.GridResourceAttributeKeys;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.grid.ChemicalGridResource;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.neoforged.fml.ModList;

public class ChemicalGridResourceFactory
implements ResourceRepositoryMapper<GridResource> {
    public GridResource apply(ResourceKey resource) {
        ChemicalResource chemicalResource = (ChemicalResource)resource;
        String name = this.getName(chemicalResource);
        String modId = this.getModId(chemicalResource);
        String modName = this.getModName(modId);
        Set<String> tags = this.getTags(chemicalResource.chemical());
        String tooltip = this.getTooltip(chemicalResource);
        return new ChemicalGridResource(chemicalResource, name, Map.of(GridResourceAttributeKeys.MOD_ID, Set.of(modId), GridResourceAttributeKeys.MOD_NAME, Set.of(modName), GridResourceAttributeKeys.TAGS, tags, GridResourceAttributeKeys.TOOLTIP, Set.of(tooltip)));
    }

    private Set<String> getTags(Chemical chemical) {
        return MekanismAPI.CHEMICAL_REGISTRY.getResourceKey((Object)chemical).flatMap(arg_0 -> ((DefaultedRegistry)MekanismAPI.CHEMICAL_REGISTRY).getHolder(arg_0)).stream().flatMap(Holder::tags).map(tagKey -> tagKey.location().getPath()).collect(Collectors.toSet());
    }

    private String getModId(ChemicalResource chemical) {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)chemical.chemical()).getNamespace();
    }

    private String getTooltip(ChemicalResource resource) {
        return this.getName(resource);
    }

    private String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse("");
    }

    private String getName(ChemicalResource chemical) {
        return chemical.chemical().getTextComponent().getString();
    }
}

