/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.grid;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ChemicalGridExtractionStrategy
implements GridExtractionStrategy {
    private final AbstractContainerMenu menu;
    private final GridOperations gridOperations;

    public ChemicalGridExtractionStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        this.menu = containerMenu;
        this.gridOperations = grid.createOperations((ResourceType)ChemicalResourceType.INSTANCE, player);
    }

    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (resource instanceof ChemicalResource) {
            ChemicalResource chemicalResource = (ChemicalResource)resource;
            if (this.isChemicalContainerOnCursor()) {
                this.extractWithContainerOnCursor(chemicalResource, extractMode);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private IChemicalHandler getChemicalStorage(ItemStack stack) {
        return (IChemicalHandler)stack.getCapability(ChemicalUtil.ITEM_CAPABILITY);
    }

    private void extractWithContainerOnCursor(ChemicalResource chemicalResource, GridExtractMode mode) {
        this.gridOperations.extract((ResourceKey)chemicalResource, mode, (resource, amount, action, source) -> {
            Chemical chemical;
            if (!(resource instanceof ChemicalResource)) return 0L;
            ChemicalResource $b$0 = (ChemicalResource)resource;
            try {
                Chemical patt1$temp;
                chemical = patt1$temp = $b$0.chemical();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            IChemicalHandler destination = this.getChemicalStorage(this.menu.getCarried());
            if (destination == null) {
                return 0L;
            }
            ChemicalStack toInsert = new ChemicalStack(chemical, amount);
            ChemicalStack remainder = destination.insertChemical(toInsert, ChemicalUtil.toMekanismAction(action));
            return amount - remainder.getAmount();
        });
    }

    private boolean isChemicalContainerOnCursor() {
        return this.getChemicalStorage(this.menu.getCarried()) != null;
    }
}

