/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.ChemicalRenderer;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mekanism.api.chemical.Chemical;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class ChemicalResourceRendering
implements ResourceRendering {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.US));

    public String formatAmount(long amount, boolean withUnits) {
        return (!withUnits ? ChemicalResourceRendering.format(amount) : ChemicalResourceRendering.formatWithUnits(amount)) + "B";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getDisplayName(ResourceKey resourceKey) {
        Chemical chemical2;
        if (!(resourceKey instanceof ChemicalResource)) return Component.empty();
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical;
            chemical2 = chemical = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return chemical2.getTextComponent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Component> getTooltip(ResourceKey resourceKey) {
        Chemical chemical2;
        if (!(resourceKey instanceof ChemicalResource)) return Collections.emptyList();
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical;
            chemical2 = chemical = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return List.of(chemical2.getTextComponent());
    }

    public void render(ResourceKey resourceKey, GuiGraphics graphics, int x, int y) {
        if (resourceKey instanceof ChemicalResource) {
            Chemical chemical;
            ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
            try {
                Chemical chemical2;
                chemical = chemical2 = chemicalResource.chemical();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ChemicalRenderer.render(graphics.pose(), x, y, chemical);
        }
    }

    public void render(ResourceKey resourceKey, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, Level level) {
        if (resourceKey instanceof ChemicalResource) {
            Chemical chemical;
            ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
            try {
                Chemical chemical2;
                chemical = chemical2 = chemicalResource.chemical();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ChemicalRenderer.render(poseStack, multiBufferSource, light, chemical);
        }
    }

    private static String formatWithUnits(long mb) {
        double buckets = ChemicalResourceRendering.convertToBuckets(mb);
        return IdentifierUtil.formatWithUnits((double)buckets);
    }

    public static String format(long mb) {
        double buckets = ChemicalResourceRendering.convertToBuckets(mb);
        return FORMATTER.format(buckets);
    }

    private static double convertToBuckets(long mb) {
        return (double)mb / 1000.0;
    }
}

