/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import mekanism.api.chemical.Chemical;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public final class ChemicalRenderer {
    private ChemicalRenderer() {
    }

    public static void render(PoseStack poseStack, int x, int y, Chemical chemical) {
        int packedRgb = chemical.getTint();
        Minecraft minecraft = Minecraft.getInstance();
        ResourceLocation icon = chemical.getIcon();
        TextureAtlasSprite sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(icon);
        ChemicalRenderer.render(poseStack, x, y, packedRgb, sprite);
    }

    public static void render(PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, Chemical chemical) {
        int packedRgb = chemical.getTint();
        Minecraft minecraft = Minecraft.getInstance();
        ResourceLocation icon = chemical.getIcon();
        TextureAtlasSprite sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(icon);
        ChemicalRenderer.render(poseStack, renderTypeBuffer, light, packedRgb, sprite);
    }

    private static void render(PoseStack poseStack, int x, int y, int packedRgb, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        int r = packedRgb >> 16 & 0xFF;
        int g = packedRgb >> 8 & 0xFF;
        int b = packedRgb & 0xFF;
        int slotXEnd = x + 16;
        int slotYEnd = y + 16;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)x, (float)slotYEnd, 0.0f).setUv(sprite.getU0(), sprite.getV1()).setColor(r, g, b, 255);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)slotXEnd, (float)slotYEnd, 0.0f).setUv(sprite.getU1(), sprite.getV1()).setColor(r, g, b, 255);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)slotXEnd, (float)y, 0.0f).setUv(sprite.getU1(), sprite.getV0()).setColor(r, g, b, 255);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)x, (float)y, 0.0f).setUv(sprite.getU0(), sprite.getV0()).setColor(r, g, b, 255);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    private static void render(PoseStack poseStack, MultiBufferSource buffers, int light, int packedRgb, TextureAtlasSprite sprite) {
        VertexConsumer buffer = buffers.getBuffer(RenderType.solid());
        float scale = 0.3f;
        float x0 = -0.15f;
        float y0 = 0.15f;
        float x1 = 0.15f;
        float y1 = -0.15f;
        Matrix4f transform = poseStack.last().pose();
        buffer.addVertex(transform, -0.15f, -0.15f, 0.0f).setColor(packedRgb).setUv(sprite.getU0(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, 0.15f, -0.15f, 0.0f).setColor(packedRgb).setUv(sprite.getU1(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, 0.15f, 0.15f, 0.0f).setColor(packedRgb).setUv(sprite.getU1(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, -0.15f, 0.15f, 0.0f).setColor(packedRgb).setUv(sprite.getU0(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
    }
}

