/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.mixin;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.zeroregard.ars_technica.item.PressurePerk;
import com.zeroregard.ars_technica.registry.DataComponentRegistry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import oshi.util.tuples.Pair;

@Mixin(value={AnimatedMagicArmor.class})
public abstract class AnimatedMagicArmorMixin {
    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")}, remap=false)
    private void inventoryTickInject(ItemStack stack, Level world, Entity player, int slotId, boolean pIsSelected, CallbackInfo ci) {
        float currentAir;
        DataComponentMap components;
        int pressurePerkCount;
        Pair holder;
        if (!world.isClientSide) {
            holder = PerkUtil.getHolderForPerk((IPerk)PressurePerk.INSTANCE, (LivingEntity)((LivingEntity)player));
            if (holder == null || holder.getA() != stack) {
                return;
            }
            pressurePerkCount = PerkUtil.countForPerk((IPerk)PressurePerk.INSTANCE, (LivingEntity)((LivingEntity)player));
            if (pressurePerkCount > 0) {
                components = stack.getComponents();
                currentAir = ((Float)components.getOrDefault((DataComponentType)DataComponentRegistry.AIR.get(), (Object)Float.valueOf(0.0f))).floatValue();
                if (!player.isUnderWater()) {
                    float airGain = (float)(2 * pressurePerkCount - 1) * 0.01f;
                    float airCap = 600 + pressurePerkCount * 300;
                    float newAir = Math.min(currentAir + airGain, airCap);
                    DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)DataComponentRegistry.AIR.get(), (Object)Float.valueOf(newAir)).build();
                    stack.applyComponents(patch);
                } else {
                    boolean second;
                    boolean bl = second = world.getGameTime() % 20L == 0L;
                    if (second) {
                        float newAir = currentAir - 1.0f;
                        DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)DataComponentRegistry.AIR.get(), (Object)Float.valueOf(newAir)).build();
                        stack.applyComponents(patch);
                    }
                }
            }
        }
        if (world.isClientSide) {
            holder = PerkUtil.getHolderForPerk((IPerk)PressurePerk.INSTANCE, (LivingEntity)((LivingEntity)player));
            if (holder == null || holder.getA() != stack) {
                return;
            }
            pressurePerkCount = PerkUtil.countForPerk((IPerk)PressurePerk.INSTANCE, (LivingEntity)((LivingEntity)player));
            if (pressurePerkCount > 0) {
                components = stack.getComponents();
                currentAir = ((Float)components.getOrDefault((DataComponentType)DataComponentRegistry.AIR.get(), (Object)Float.valueOf(0.0f))).floatValue();
                player.getPersistentData().putInt("VisualBacktankAir", Math.round(currentAir));
            }
        }
    }
}

