/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.kinetics;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.zeroregard.ars_technica.entity.ArcaneWhirlEntity;
import com.zeroregard.ars_technica.kinetics.WhirlProcessing;
import com.zeroregard.ars_technica.network.ParticleEffectPacket;
import com.zeroregard.ars_technica.registry.ParticleRegistry;
import com.zeroregard.ars_technica.registry.SoundRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WhirlCurrent {
    private final ArcaneWhirlEntity source;
    private AABB bounds;
    private List<ItemEntity> affectedEntities;
    private float radius;
    private int tickCount = 0;
    private double tangentialFactor = 0.25;
    private double pullFactor = 3.0;

    public WhirlCurrent(ArcaneWhirlEntity source) {
        this.source = source;
        this.radius = source.getRadius();
        Vec3 centerPos = source.getPosition(1.0f);
        this.bounds = new AABB(centerPos.subtract((double)this.radius, (double)this.radius, (double)this.radius), centerPos.add((double)this.radius, (double)this.radius, (double)this.radius));
    }

    public void tick(SpellResolver whirlOwner) {
        ++this.tickCount;
        Level world = this.source.getLevel();
        if (world == null) {
            return;
        }
        this.tickAffectedEntities(world, whirlOwner);
    }

    protected void tickAffectedEntities(Level world, SpellResolver whirlOwner) {
        this.affectedEntities = world.getEntitiesOfClass(ItemEntity.class, this.bounds);
        if (this.tickCount % 4 == 0) {
            this.sendWhirlParticles(world, this.source.getProcessor());
        }
        Iterator<ItemEntity> iterator = this.affectedEntities.iterator();
        while (iterator.hasNext()) {
            ItemEntity itemEntity;
            Entity entity = (Entity)iterator.next();
            if (!entity.isAlive() || !entity.getBoundingBox().intersects(this.bounds)) {
                iterator.remove();
                continue;
            }
            this.moveItem(entity);
            FanProcessingType processingType = this.source.getProcessor();
            entity.hurtMarked = true;
            if (processingType == null || !(entity instanceof ItemEntity) || !WhirlProcessing.canProcess((ItemEntity)(itemEntity = (ItemEntity)entity), (FanProcessingType)processingType)) continue;
            Vec3 itemPosition = itemEntity.getPosition(1.0f);
            if (WhirlProcessing.applyProcessing(itemEntity, processingType, world, whirlOwner)) {
                this.sendProcessingFinishedSound(itemPosition, processingType);
            }
            if (this.tickCount % 8 == 0) {
                this.sendProcessingSound(itemPosition, processingType);
                this.sendProcessingParticles(world, itemEntity, processingType);
            }
            this.sendProcessingParticles(world, itemEntity, processingType);
        }
    }

    private void moveItem(Entity entity) {
        Vec3 direction = this.source.position().subtract(entity.position()).normalize();
        double distance = entity.position().distanceTo(this.source.position());
        Vec3 motion = entity.getDeltaMovement();
        double heightDifference = Math.abs(entity.position().y - this.source.position().y);
        double heightFactor = Math.max(0.0, 1.0 - heightDifference);
        Vec3 tangentialMotion = new Vec3(-direction.z, 0.0, direction.x).scale(this.tangentialFactor * heightFactor * (double)(this.radius / 3.0f) * (double)this.source.getScaledSpeed() * 0.5);
        Vec3 pull = direction.scale(this.pullFactor * (Math.sqrt(this.radius) - distance * 1.5) * heightFactor * (double)(1.0f / this.radius) * (double)this.source.getScaledSpeed() * 0.5);
        if (pull.length() > 0.5) {
            pull = pull.normalize().scale(0.1 * (double)this.radius);
        }
        entity.setDeltaMovement(motion.add(tangentialMotion).subtract(pull));
        entity.fallDistance = 0.0f;
    }

    private void sendProcessingSound(Vec3 itemPos, FanProcessingType processingType) {
        SoundEvent event = (SoundEvent)SoundRegistry.WHIRL_PROCESS_AFFECT_FIRE.get();
        if (processingType == AllFanProcessingTypes.SPLASHING) {
            event = (SoundEvent)SoundRegistry.WHIRL_PROCESS_AFFECT_WATER.get();
        }
        this.sendSoundEvent(itemPos, event);
    }

    private void sendProcessingFinishedSound(Vec3 itemPos, FanProcessingType processingType) {
        SoundEvent event = SoundEvents.FIRE_EXTINGUISH;
        if (processingType == AllFanProcessingTypes.SPLASHING) {
            event = SoundEvents.PLAYER_SPLASH;
        }
        this.sendSoundEvent(itemPos, event);
    }

    private void sendSoundEvent(Vec3 pos, SoundEvent event) {
        if (event != null) {
            this.source.getLevel().playSound(null, pos.x, pos.y, pos.z, event, SoundSource.AMBIENT, 0.25f, 1.0f);
        }
    }

    private void sendWhirlParticles(Level world, FanProcessingType processingType) {
        if (processingType == null) {
            return;
        }
        ParticleColor color = ParticleColor.WHITE;
        if (processingType == AllFanProcessingTypes.BLASTING || processingType == AllFanProcessingTypes.HAUNTING || processingType == AllFanProcessingTypes.SMOKING) {
            color = new ParticleColor(32, 32, 32);
        }
        ParticleEffectPacket.send(world, ParticleColor.fromInt((int)color.getColor()), (ParticleType)ParticleRegistry.SPIRAL_DUST_TYPE.get(), this.source.getPosition(1.0f));
    }

    private void sendProcessingParticles(Level world, ItemEntity itemEntity, FanProcessingType processingType) {
        Vec3 itemPos = itemEntity.position();
        Object particleType = processingType == AllFanProcessingTypes.BLASTING ? ParticleTypes.SMOKE : (processingType == AllFanProcessingTypes.HAUNTING ? ParticleTypes.SOUL_FIRE_FLAME : (processingType == AllFanProcessingTypes.SMOKING ? ParticleTypes.POOF : ParticleTypes.DUST));
        ParticleEffectPacket.send(world, particleType, itemPos);
    }

    public void stopAffectedItems() {
        if (this.affectedEntities == null) {
            return;
        }
        for (ItemEntity item : this.affectedEntities) {
            item.setDeltaMovement(Vec3.ZERO);
            item.hurtMarked = true;
        }
        this.affectedEntities.clear();
    }

    private static UUID getProcessingId(Entity entity) {
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (nbt.contains("CreateData") && (createData = nbt.getCompound("CreateData")).contains("WhirlwindId")) {
            return createData.getUUID("WhirlwindId");
        }
        return null;
    }
}

