/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class RecipeHelpers {
    public static boolean isChanceBased(ItemStack input, ProcessingRecipe<?> recipe) {
        List rollables = recipe.getRollableResults();
        return rollables.stream().anyMatch(rollable -> input.getItem() == rollable.getStack().getItem() && rollable.getChance() < 1.0f);
    }

    public static Optional<RecipeHolder<Recipe<SingleRecipeInput>>> getPressingRecipeForItemStack(ItemStack input, Level world) {
        SingleRecipeInput wrapper = new SingleRecipeInput(input);
        return world.getRecipeManager().getRecipeFor(AllRecipeTypes.PRESSING.getType(), (RecipeInput)wrapper, world);
    }

    public static Optional<ProcessingRecipe<RecipeWrapper>> getCrushingRecipeForItemStack(ItemStack input, Level world) {
        ItemStackHandler itemHandler = new ItemStackHandler(1);
        itemHandler.setStackInSlot(0, input);
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)itemHandler);
        Optional recipeHolder = world.getRecipeManager().getRecipeFor(AllRecipeTypes.CRUSHING.getType(), (RecipeInput)wrapper, world);
        if (recipeHolder.isEmpty()) {
            recipeHolder = world.getRecipeManager().getRecipeFor(AllRecipeTypes.MILLING.getType(), (RecipeInput)wrapper, world);
        }
        return recipeHolder.map(RecipeHolder::value).filter(recipe -> recipe instanceof ProcessingRecipe).map(recipe -> (ProcessingRecipe)recipe);
    }

    public static Optional<ProcessingRecipe<RecipeWrapper>> getSplashingRecipeForItemStack(ItemStack input, Level world) {
        return RecipeHelpers.getProcessingRecipe(input, world, AllRecipeTypes.SPLASHING.getType());
    }

    public static Optional<ProcessingRecipe<RecipeWrapper>> getHauntingRecipeForItemStack(ItemStack input, Level world) {
        return RecipeHelpers.getProcessingRecipe(input, world, AllRecipeTypes.HAUNTING.getType());
    }

    private static <T extends ProcessingRecipe<RecipeWrapper>> Optional<T> getProcessingRecipe(ItemStack input, Level world, RecipeType<T> recipeType) {
        ItemStackHandler itemHandler = new ItemStackHandler(1);
        itemHandler.setStackInSlot(0, input);
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)itemHandler);
        Optional recipeHolder = world.getRecipeManager().getRecipeFor(recipeType, (RecipeInput)wrapper, world);
        return recipeHolder.map(RecipeHolder::value);
    }
}

