/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.datagen;

import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.Codec;
import com.simibubi.create.AllItems;
import com.zeroregard.ars_technica.datagen.ATTagsProvider;
import com.zeroregard.ars_technica.datagen.Setup;
import com.zeroregard.ars_technica.item.PressurePerk;
import com.zeroregard.ars_technica.recipe.TechnomancerArmorRecipe;
import com.zeroregard.ars_technica.registry.ItemRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class ArsProviders {
    static String root = "ars_technica";

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
            this.collectJsons(pOutput);
            ArrayList futures = new ArrayList();
            return Setup.provider.thenCompose(registry -> {
                for (ImbuementRecipe g : this.recipes) {
                    Path path = this.getRecipePath(this.output, g.id.getPath());
                    futures.add(DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)registry, (Codec)ImbuementRecipe.CODEC, (Object)g, (Path)path));
                }
                return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            });
        }

        public void collectJsons(CachedOutput cache) {
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Example Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider
    implements IConditionBuilder {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            this.addIngredientRecipes();
            this.addTechnomancerArmorRecipes();
            this.addEquipmentRecipes();
            this.addCurioRecipes();
            this.addThreadRecipes();
            Path output = this.generator.getPackOutput().getOutputFolder();
            for (ApparatusRecipeBuilder.RecipeWrapper g : this.recipes) {
                if (g == null) continue;
                Path path = EnchantingAppProvider.getRecipePath(output, g.id().getPath());
                this.saveStable(cache, g.serialize(), path);
            }
        }

        protected void addIngredientRecipes() {
            this.recipes.add(this.builder().withResult(ItemRegistry.CALIBRATED_PRECISION_MECHANISM).withReagent((ItemLike)AllItems.PRECISION_MECHANISM).withPedestalItem(4, Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD})).withPedestalItem(4, Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.SOURCE_GEM})).withSourceCost(500).build());
        }

        protected void addEquipmentRecipes() {
            this.recipes.add(this.builder().withResult(ItemRegistry.RUNIC_SPANNER).withReagent((ItemLike)AllItems.WRENCH).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})).withPedestalItem(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.MANIPULATION_ESSENCE})).withSourceCost(500).build());
        }

        protected void addCurioRecipes() {
            this.recipes.add(this.builder().withResult(ItemRegistry.TRANSMUTATION_FOCUS).withReagent((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, (ItemLike)AllItems.BRASS_INGOT).withPedestalItem((ItemLike)Items.RABBIT_FOOT).withPedestalItem(ItemRegistry.CALIBRATED_PRECISION_MECHANISM).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD})).build());
            this.recipes.add(this.builder().withResult(ItemRegistry.SPY_MONOCLE).withReagent((ItemLike)Items.SPYGLASS).withPedestalItem(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).build());
        }

        protected void addThreadRecipes() {
            this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(PressurePerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(3, Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.AIR_ESSENCE})).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{AllItems.COPPER_BACKTANK})).withPedestalItem(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).build());
        }

        ArmorBuilder Abuilder() {
            return new ArmorBuilder();
        }

        protected void addTechnomancerArmorRecipes() {
            this.recipes.add(this.Abuilder().withResult((ItemLike)ItemRegistry.TECHNOMANCER_HELMET.get()).withReagent(Ingredient.of(ATTagsProvider.ATItemTagsProvider.MAGIC_HOOD)).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem((ItemLike)AllItems.BRASS_INGOT).withPedestalItem((ItemLike)AllItems.GOGGLES).withSourceCost(7000).keepNbtOfReagent(true).build());
            this.recipes.add(this.Abuilder().withResult((ItemLike)ItemRegistry.TECHNOMANCER_CHESTPLATE.get()).withReagent(Ingredient.of(ATTagsProvider.ATItemTagsProvider.MAGIC_ROBE)).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem(2, (ItemLike)AllItems.BRASS_INGOT).withSourceCost(7000).keepNbtOfReagent(true).build());
            this.recipes.add(this.Abuilder().withResult((ItemLike)ItemRegistry.TECHNOMANCER_LEGGINGS.get()).withReagent(Ingredient.of(ATTagsProvider.ATItemTagsProvider.MAGIC_LEG)).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem(2, (ItemLike)AllItems.BRASS_INGOT).withSourceCost(7000).keepNbtOfReagent(true).build());
            this.recipes.add(this.Abuilder().withResult((ItemLike)ItemRegistry.TECHNOMANCER_BOOTS.get()).withReagent(Ingredient.of(ATTagsProvider.ATItemTagsProvider.MAGIC_BOOT)).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem(2, (ItemLike)AllItems.BRASS_INGOT).withSourceCost(7000).keepNbtOfReagent(true).build());
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Example Apparatus";
        }

        public static class ArmorBuilder
        extends ApparatusRecipeBuilder {
            public ApparatusRecipeBuilder.RecipeWrapper<EnchantingApparatusRecipe> build() {
                ApparatusRecipeBuilder.RecipeWrapper wrapper = super.build();
                return new ApparatusRecipeBuilder.RecipeWrapper(wrapper.id(), (EnchantingApparatusRecipe)new TechnomancerArmorRecipe(wrapper.recipe().reagent(), wrapper.recipe().result(), wrapper.recipe().pedestalItems(), wrapper.recipe().sourceCost()), TechnomancerArmorRecipe.CODEC);
            }
        }
    }
}

