/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zeroregard.ars_technica.ArsTechnica;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

@OnlyIn(value=Dist.CLIENT)
public class SpyMonocleCurioRenderer
implements ICurioRenderer {
    public static final ModelLayerLocation SPY_MONOCLE_LAYER = new ModelLayerLocation(ArsTechnica.prefix("spy_monocle"), "monocle");
    private final HumanoidModel<LivingEntity> model;

    public SpyMonocleCurioRenderer(ModelPart part) {
        this.model = new HumanoidModel(part);
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.setupAnim(slotContext.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.model.prepareMobModel(slotContext.entity(), limbSwing, limbSwingAmount, partialTicks);
        matrixStack.pushPose();
        if (slotContext.entity().isCrouching()) {
            matrixStack.translate(0.0f, 0.26f, 0.0f);
        }
        ResourceLocation resourceLoc = ArsTechnica.prefix("textures/entity/spy_monocle.png");
        VertexConsumer vertexConsumer = renderTypeBuffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)resourceLoc));
        this.model.head.render(matrixStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(7, 0).addBox(-3.0f, -4.9f, -4.5f, 2.0f, 2.0f, 0.5f, new CubeDeformation(0.0f)).texOffs(8, 14).addBox(-2.9f, -4.8f, -4.7f, 1.8f, 1.8f, 0.2f, new CubeDeformation(0.0f)).texOffs(11, 14).addBox(-2.8f, -4.7f, -4.9f, 1.6f, 1.6f, 0.2f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(7, 7).addBox(-0.2f, -0.2f, 0.3f, 1.0f, 1.0f, 0.2f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-4.3f, (float)-5.4f, (float)0.0f, (float)0.0f, (float)0.7854f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16);
    }
}

