/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.entity;

import com.zeroregard.ars_technica.client.entity.GenericRenderer;
import com.zeroregard.ars_technica.entity.Colorable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.Color;

public class ArcaneEntityRendererBase<T extends Entity & Colorable>
extends GenericRenderer<T> {
    protected final GeoModel<T> model = this.getGeoModel();

    public ArcaneEntityRendererBase(EntityRendererProvider.Context context, GeoModel<T> model) {
        super(context, model);
    }

    @Override
    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucentEmissive((ResourceLocation)texture, (boolean)false);
    }

    public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        float alpha = (float)((Colorable)animatable).getAlpha();
        Color color = ((Colorable)animatable).getColor();
        if (color == null) {
            return Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        Color finalColor = Color.ofRGBA((float)color.getRedFloat(), (float)color.getGreenFloat(), (float)color.getBlueFloat(), (float)alpha);
        return finalColor;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.model.getTextureResource(entity);
    }
}

