/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.events.reloader;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;

public class RaidBossReloadListener
implements ResourceManagerReloadListener {
    public void onResourceManagerReload(@NotNull ResourceManager manager) {
        RaidRegistry.clear();
        manager.listResources("raid/boss", path -> path.toString().endsWith(".json")).forEach((id, resource) -> {
            try (InputStream input = resource.open();){
                JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(input, StandardCharsets.UTF_8)).getAsJsonObject();
                ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace("raid/boss/", "").replace(".json", ""));
                Optional<RaidBoss> raidBossOpt = RaidBoss.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().map(Pair::getFirst);
                raidBossOpt.ifPresent(raidBoss -> {
                    raidBoss.setId(key);
                    RaidRegistry.register(raidBoss);
                });
            }
            catch (Exception e) {
                CobblemonRaidDens.LOGGER.error("Failed to load raid boss {}", id, (Object)e);
            }
        });
        RaidRegistry.populateWeightedList();
        RaidTier.updateRandom();
    }
}

