/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.worldgen.BOPFeatureUtils;
import biomesoplenty.worldgen.feature.BOPBaseFeatures;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class BOPCaveFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_GROTTO_FLOOR_PLANTS = BOPFeatureUtils.createKey("glowing_grotto_floor_plants");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_GROTTO_CEILING_PLANTS = BOPFeatureUtils.createKey("glowing_grotto_ceiling_plants");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_MOSS_PATCH = BOPFeatureUtils.createKey("glowing_moss_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_MOSS_PATCH_BONEMEAL = BOPFeatureUtils.createKey("glowing_moss_patch_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_MOSS_PATCH_BONEMEAL_BOTTOM = BOPFeatureUtils.createKey("glowing_moss_patch_bonemeal_bottom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_PLANTS = BOPFeatureUtils.createKey("mud_plants");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_PATCH = BOPFeatureUtils.createKey("mud_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWWORM_SILK = BOPFeatureUtils.createKey("glowworm_silk");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GIANT_GLOWSHROOM_CAVE = BOPFeatureUtils.createKey("giant_glowshroom_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_GLOWSHROOM_CAVE = BOPFeatureUtils.createKey("huge_glowshroom_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MEDIUM_GLOWSHROOM_CAVE = BOPFeatureUtils.createKey("medium_glowshroom_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_GLOWSHROOM_CAVE = BOPFeatureUtils.createKey("small_glowshroom_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EXTRA_GLOW_LICHEN = BOPFeatureUtils.createKey("extra_glow_lichen");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HANGING_COBWEB = BOPFeatureUtils.createKey("hanging_cobweb");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CORNER_COBWEBS = BOPFeatureUtils.createKey("corner_cobwebs");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIDER_EGG = BOPFeatureUtils.createKey("spider_egg");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STRINGY_COBWEB = BOPFeatureUtils.createKey("stringy_cobweb");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEBBING = BOPFeatureUtils.createKey("webbing");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter configuredFeatureGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        BOPCaveFeatures.register(context, GLOWING_GROTTO_FLOOR_PLANTS, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)BOPBlocks.GLOWSHROOM.defaultBlockState(), 6).add((Object)BOPBlocks.GLOWING_MOSS_CARPET.defaultBlockState(), 25))));
        Holder.Reference GLOWING_GROTTO_FLOOR_PLANTS = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.GLOWING_GROTTO_FLOOR_PLANTS);
        BOPCaveFeatures.register(context, GLOWING_GROTTO_CEILING_PLANTS, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.GLOWWORM_SILK)));
        Holder.Reference GLOWING_GROTTO_CEILING_PLANTS = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.GLOWING_GROTTO_CEILING_PLANTS);
        BOPCaveFeatures.register(context, GLOWING_MOSS_PATCH, Feature.VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.GLOWING_MOSS_BLOCK), PlacementUtils.inlinePlaced((Holder)GLOWING_GROTTO_FLOOR_PLANTS, (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.5f, (IntProvider)UniformInt.of((int)4, (int)7), 0.3f));
        BOPCaveFeatures.register(context, GLOWING_MOSS_PATCH_BONEMEAL, Feature.VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.GLOWING_MOSS_BLOCK), PlacementUtils.inlinePlaced((Holder)GLOWING_GROTTO_FLOOR_PLANTS, (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.4f, (IntProvider)UniformInt.of((int)1, (int)2), 0.75f));
        BOPCaveFeatures.register(context, GLOWING_MOSS_PATCH_BONEMEAL_BOTTOM, Feature.VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.GLOWING_MOSS_BLOCK), PlacementUtils.inlinePlaced((Holder)GLOWING_GROTTO_CEILING_PLANTS, (PlacementModifier[])new PlacementModifier[0]), CaveSurface.CEILING, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.4f, (IntProvider)UniformInt.of((int)1, (int)2), 0.75f));
        BOPCaveFeatures.register(context, MUD_PLANTS, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.GLOWING_MOSS_CARPET)));
        Holder.Reference MUD_PLANTS = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.MUD_PLANTS);
        BOPCaveFeatures.register(context, MUD_PATCH, Feature.VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MUD), PlacementUtils.inlinePlaced((Holder)MUD_PLANTS, (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.05f, (IntProvider)UniformInt.of((int)4, (int)7), 0.3f));
        BOPCaveFeatures.register(context, GLOWWORM_SILK, Feature.BLOCK_COLUMN, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)UniformInt.of((int)0, (int)11), 2).add((Object)UniformInt.of((int)0, (int)5), 3).add((Object)UniformInt.of((int)0, (int)2), 10).build()), (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.GLOWWORM_SILK_STRAND)), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.GLOWWORM_SILK))), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true));
        BOPCaveFeatures.register(context, GIANT_GLOWSHROOM_CAVE, BOPBaseFeatures.GIANT_GLOWSHROOM, NoneFeatureConfiguration.INSTANCE);
        BOPCaveFeatures.register(context, HUGE_GLOWSHROOM_CAVE, BOPBaseFeatures.HUGE_GLOWSHROOM, NoneFeatureConfiguration.INSTANCE);
        BOPCaveFeatures.register(context, MEDIUM_GLOWSHROOM_CAVE, BOPBaseFeatures.MEDIUM_GLOWSHROOM, NoneFeatureConfiguration.INSTANCE);
        BOPCaveFeatures.register(context, SMALL_GLOWSHROOM_CAVE, BOPBaseFeatures.SMALL_GLOWSHROOM, NoneFeatureConfiguration.INSTANCE);
        BOPCaveFeatures.register(context, EXTRA_GLOW_LICHEN, BOPBaseFeatures.EXTRA_GLOW_LICHEN, NoneFeatureConfiguration.INSTANCE);
        BOPCaveFeatures.register(context, HANGING_COBWEB, Feature.BLOCK_COLUMN, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)UniformInt.of((int)0, (int)15), 2).add((Object)UniformInt.of((int)0, (int)3), 3).add((Object)UniformInt.of((int)0, (int)7), 3).build()), (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.HANGING_COBWEB_STRAND)), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.HANGING_COBWEB))), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true));
        BOPCaveFeatures.register(context, CORNER_COBWEBS, BOPBaseFeatures.CORNER_COBWEBS, NoneFeatureConfiguration.INSTANCE);
        BOPCaveFeatures.register(context, SPIDER_EGG, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.SPIDER_EGG)));
        BOPCaveFeatures.register(context, STRINGY_COBWEB, BOPBaseFeatures.STRINGY_COBWEB, NoneFeatureConfiguration.INSTANCE);
        BOPCaveFeatures.register(context, WEBBING, BOPBaseFeatures.WEBBING, NoneFeatureConfiguration.INSTANCE);
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey, F feature, FC configuration) {
        context.register(configuredFeatureKey, (Object)new ConfiguredFeature(feature, configuration));
    }
}

