/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.dimension;

import java.util.Optional;
import net.commoble.hyperbox.dimension.ReturnPoint;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class TeleportHelper {
    public static void sendPlayerToDimension(ServerPlayer serverPlayer, ServerLevel targetLevel, Vec3 targetVec) {
        targetLevel.getChunk(new BlockPos((int)targetVec.x, (int)targetVec.y, (int)targetVec.z));
        serverPlayer.teleportTo(targetLevel, targetVec.x(), targetVec.y(), targetVec.z(), serverPlayer.getYRot(), serverPlayer.getXRot());
    }

    public static void ejectPlayerFromDeadWorld(ServerPlayer serverPlayer) {
        ReturnPoint.getReturnPoint(serverPlayer).evaluate((targetLevel, pos) -> {
            if (targetLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)targetLevel;
                TeleportHelper.sendPlayerToDimension(serverPlayer, serverLevel, Vec3.atCenterOf((Vec3i)pos));
            }
            return Optional.empty();
        });
    }
}

