/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.item.weapon.weapons;

import java.util.List;
import mod.azure.azurelib.sblforked.util.RandomUtil;
import net.bandit.hyrule_terrors.item.HyruleWeaponMaterials;
import net.bandit.hyrule_terrors.item.weapon.dispatcher.HyruleItemDispatcher;
import net.bandit.hyrule_terrors.registry.TabRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BokoblinArm
extends Item {
    public final HyruleItemDispatcher dispatcher = new HyruleItemDispatcher();

    public BokoblinArm(Item.Properties properties) {
        super(new Item.Properties().attributes(SwordItem.createAttributes((Tier)HyruleWeaponMaterials.BOKOBLIN_TIER, (int)2, (float)-1.0f)).durability(100).rarity(Rarity.UNCOMMON).arch$tab(TabRegistry.HYRULE_TERRORS_TAB));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!level.isClientSide() && isSelected && entity instanceof Player) {
            Player player = (Player)entity;
            this.dispatcher.serverFire((Entity)player, stack);
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            attacker.level().playSound(null, attacker.blockPosition(), SoundEvents.SKELETON_HURT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!player.getAbilities().instabuild && RandomUtil.RANDOM.nextFloat() < 0.1f) {
                player.drop(stack.copy(), false);
                player.setItemInHand(player.getUsedItemHand(), ItemStack.EMPTY);
                player.displayClientMessage((Component)Component.literal((String)"The Bokoblin Arm slips from your hand!").withStyle(ChatFormatting.GRAY), true);
            }
        }
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.Bokoblin_arm.tooltip").withStyle(ChatFormatting.BLUE));
            tooltipComponents.add((Component)Component.translatable((String)"item.bokoblin_arm.tooltip1").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.hyrule_terrors.hold_shift"));
        }
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repairWith) {
        return repairWith.is(Items.BONE) || super.isValidRepairItem(toRepair, repairWith);
    }
}

