/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.hyrule_terrors.item.armor.client.animator;

import java.util.Optional;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import net.bandit.hyrule_terrors.HyruleTerrorsMod;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EvilSpiritAnimator
extends AzItemAnimator {
    private static final ResourceLocation ANIMATIONS = HyruleTerrorsMod.modResource("animations/armor/evil_spirit.animation.json");

    public void registerControllers(AzAnimationControllerContainer<ItemStack> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"base_controller").build(), new AzAnimationController[0]);
    }

    @NotNull
    public ResourceLocation getAnimationLocation(ItemStack animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(ItemStack stack, float partialTick) {
        super.setCustomAnimations((Object)stack, partialTick);
        AzBakedModel model = this.context().boneCache().getBakedModel();
        if (model == null) {
            return;
        }
        Optional capeOpt = model.getBone("cape");
        if (capeOpt.isEmpty()) {
            return;
        }
        AzBone cape = (AzBone)capeOpt.get();
        Player player = ClientUtils.getClientPlayer();
        if (player == null) {
            return;
        }
        float h = partialTick;
        double dx = Mth.lerp((double)h, (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)h, (double)player.xo, (double)player.getX());
        double dy = Mth.lerp((double)h, (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)h, (double)player.yo, (double)player.getY());
        double dz = Mth.lerp((double)h, (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)h, (double)player.zo, (double)player.getZ());
        float bodyRot = Mth.rotLerp((float)h, (float)player.yBodyRotO, (float)player.yBodyRot);
        double sin = Mth.sin((float)(bodyRot * ((float)Math.PI / 180)));
        double cos = -Mth.cos((float)(bodyRot * ((float)Math.PI / 180)));
        float verticalMotion = (float)dy * 10.0f;
        verticalMotion = Mth.clamp((float)verticalMotion, (float)-6.0f, (float)32.0f);
        float capeSwayX = (float)(dx * sin + dz * cos) * 100.0f;
        capeSwayX = Mth.clamp((float)capeSwayX, (float)0.0f, (float)150.0f);
        float capeSwayZ = (float)(dx * cos - dz * sin) * 100.0f;
        capeSwayZ = Mth.clamp((float)capeSwayZ, (float)-20.0f, (float)20.0f);
        if (capeSwayX < 0.0f) {
            capeSwayX = 0.0f;
        }
        float walkBob = Mth.lerp((float)h, (float)player.oBob, (float)player.bob);
        verticalMotion += Mth.sin((float)(Mth.lerp((float)h, (float)player.walkDistO, (float)player.walkDist) * 6.0f)) * 8.0f * walkBob;
        if (player.isCrouching()) {
            verticalMotion += 10.0f;
        }
        float baseX = 0.1f;
        float baseY = 0.0f;
        float baseZ = 0.0f;
        cape.setRotX(baseX - (capeSwayX / 200.0f + verticalMotion / 40.0f));
        cape.setRotY(baseY);
        cape.setRotZ(baseZ + capeSwayZ / 180.0f);
    }
}

