/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.util.codec.TagModifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class ModifyTagRegistry {
    public static final ResourceKey<Registry<MapCodec<? extends TagModifier>>> TAG_MODIFIER_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ArsAdditions.prefix("tag_modifiers"));
    public static final Registry<MapCodec<? extends TagModifier>> TAG_MODIFIER_REGISTRY = new RegistryBuilder(TAG_MODIFIER_REGISTRY_KEY).create();
    public static final DeferredRegister<MapCodec<? extends TagModifier>> TAG_MODIFIER = DeferredRegister.create(TAG_MODIFIER_REGISTRY, (String)"ars_additions");
    private static final DeferredHolder<MapCodec<? extends TagModifier>, MapCodec<RemoveGuaranteedDrops>> REMOVE_GUARANTEED_DROPS = TAG_MODIFIER.register("remove_guaranteed_drops", () -> RemoveGuaranteedDrops.CODEC);
    private static final DeferredHolder<MapCodec<? extends TagModifier>, MapCodec<RemoveTag>> REMOVE_TAG = TAG_MODIFIER.register("remove_tag", () -> RemoveTag.CODEC);
    private static final DeferredHolder<MapCodec<? extends TagModifier>, MapCodec<SetTag>> SET_TAG = TAG_MODIFIER.register("set_tag", () -> SetTag.CODEC);
    private static final DeferredHolder<MapCodec<? extends TagModifier>, MapCodec<AppendTag>> APPEND_TAG = TAG_MODIFIER.register("append_tag", () -> AppendTag.CODEC);

    public record AppendTag(Map<String, Tag> append) implements TagModifier
    {
        private static final Codec<Tag> TAG_CODEC = Codec.PASSTHROUGH.xmap(dynamic -> (Tag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue(), tag -> new Dynamic((DynamicOps)NbtOps.INSTANCE, tag));
        public static final MapCodec<AppendTag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TAG_CODEC).fieldOf("append").forGetter(AppendTag::append)).apply((Applicative)instance, AppendTag::new));

        public MapCodec<AppendTag> type() {
            return (MapCodec)APPEND_TAG.get();
        }

        private void appendTag(CompoundTag nbt, ArrayDeque<String> compounds, Tag value) {
            if (compounds.isEmpty()) {
                return;
            }
            String first = compounds.pollFirst();
            if (compounds.isEmpty()) {
                ListTag list = nbt.getList(first, (int)value.getId());
                list.add((Object)value);
                nbt.put(first, (Tag)list);
                return;
            }
            this.appendTag(nbt.getCompound(first), compounds, value);
        }

        @Override
        public void modify(CompoundTag nbt) {
            for (Map.Entry<String, Tag> entry : this.append().entrySet()) {
                String tag = entry.getKey();
                Tag value = entry.getValue();
                ArrayDeque<String> compounds = new ArrayDeque<String>(List.of(tag.split("\\.")));
                this.appendTag(nbt, compounds, value);
            }
        }
    }

    public record SetTag(Map<String, Tag> set) implements TagModifier
    {
        private static final Codec<Tag> TAG_CODEC = Codec.PASSTHROUGH.xmap(dynamic -> (Tag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue(), tag -> new Dynamic((DynamicOps)NbtOps.INSTANCE, tag));
        public static final MapCodec<SetTag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TAG_CODEC).fieldOf("set").forGetter(SetTag::set)).apply((Applicative)instance, SetTag::new));

        public MapCodec<SetTag> type() {
            return (MapCodec)SET_TAG.get();
        }

        private void setTag(CompoundTag nbt, ArrayDeque<String> compounds, Tag value) {
            if (compounds.isEmpty()) {
                return;
            }
            String first = compounds.pollFirst();
            if (compounds.isEmpty()) {
                nbt.put(first, value);
                return;
            }
            this.setTag(nbt.getCompound(first), compounds, value);
        }

        @Override
        public void modify(CompoundTag nbt) {
            for (Map.Entry<String, Tag> entry : this.set().entrySet()) {
                String tag = entry.getKey();
                Tag value = entry.getValue();
                ArrayDeque<String> compounds = new ArrayDeque<String>(List.of(tag.split("\\.")));
                this.setTag(nbt, compounds, value);
            }
        }
    }

    public record RemoveTag(List<String> strip) implements TagModifier
    {
        public static MapCodec<RemoveTag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("strip_tags", List.of()).forGetter(RemoveTag::strip)).apply((Applicative)instance, RemoveTag::new));

        public MapCodec<RemoveTag> type() {
            return (MapCodec)REMOVE_TAG.get();
        }

        private void removeTag(CompoundTag nbt, ArrayDeque<String> compounds) {
            if (nbt.isEmpty()) {
                return;
            }
            if (compounds.isEmpty()) {
                return;
            }
            String first = compounds.pollFirst();
            if (compounds.isEmpty()) {
                nbt.remove(first);
                return;
            }
            this.removeTag(nbt.getCompound(first), compounds);
        }

        @Override
        public void modify(CompoundTag nbt) {
            List<String> tags = this.strip();
            if (tags.isEmpty()) {
                for (String key : nbt.getAllKeys()) {
                    nbt.remove(key);
                }
                return;
            }
            for (String tag : this.strip()) {
                ArrayDeque<String> compounds = new ArrayDeque<String>(List.of(tag.split("\\.")));
                this.removeTag(nbt, compounds);
            }
        }
    }

    public record RemoveGuaranteedDrops() implements TagModifier
    {
        public static MapCodec<RemoveGuaranteedDrops> CODEC = MapCodec.unit(RemoveGuaranteedDrops::new);

        public MapCodec<RemoveGuaranteedDrops> type() {
            return (MapCodec)REMOVE_GUARANTEED_DROPS.get();
        }

        private void removeGuaranteedDrops(CompoundTag tag, String key) {
            if (!tag.contains(key)) {
                return;
            }
            ListTag list = tag.getList(key, 5);
            for (int i = 0; i < list.size(); ++i) {
                float chance = list.getFloat(i);
                if (chance != 2.0f) continue;
                list.set(i, (Tag)FloatTag.valueOf((float)-327.67f));
            }
        }

        @Override
        public void modify(CompoundTag nbt) {
            this.removeGuaranteedDrops(nbt, "HandDropChances");
            this.removeGuaranteedDrops(nbt, "ArmorDropChances");
        }
    }
}

