/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.forge;

import com.google.gson.internal.LinkedTreeMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import me.shedaniel.rei.plugin.client.DefaultClientPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;

public class DefaultClientPluginImpl
extends DefaultClientPlugin {
    @Override
    public void registerForgePotions(DisplayRegistry registry, BuiltinClientPlugin clientPlugin) {
        PotionBrewing brewing = Minecraft.getInstance().level.potionBrewing();
        DefaultClientPluginImpl.registerVanillaPotions(brewing, registry, clientPlugin);
        for (IBrewingRecipe recipe : brewing.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
            clientPlugin.registerBrewingRecipe(brewingRecipe.getInput(), brewingRecipe.getIngredient(), brewingRecipe.getOutput().copy());
        }
    }

    private static void registerVanillaPotions(PotionBrewing brewing, DisplayRegistry registry, BuiltinClientPlugin clientPlugin) {
        Holder to;
        Ingredient ingredient;
        Holder from;
        Set<Holder> potions = Collections.newSetFromMap(new LinkedTreeMap(Comparator.comparing(Holder::getRegisteredName), false));
        for (Ingredient container : brewing.containers) {
            for (PotionBrewing.Mix mix : brewing.potionMixes) {
                from = mix.from();
                ingredient = mix.ingredient;
                to = mix.to();
                Ingredient base = Ingredient.of(Arrays.stream(container.getItems()).map(ItemStack::copy).peek(stack -> stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(from))));
                ItemStack output = Arrays.stream(container.getItems()).map(ItemStack::copy).peek(stack -> stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(to))).findFirst().orElse(ItemStack.EMPTY);
                clientPlugin.registerBrewingRecipe(base, ingredient, output);
                potions.add(from);
                potions.add(to);
            }
        }
        for (Holder potion : potions) {
            for (PotionBrewing.Mix mix : brewing.containerMixes) {
                from = mix.from();
                ingredient = mix.ingredient();
                to = mix.to();
                ItemStack baseStack = new ItemStack(from);
                baseStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
                Ingredient base = Ingredient.of((ItemStack[])new ItemStack[]{baseStack});
                ItemStack output = new ItemStack(to);
                output.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
                clientPlugin.registerBrewingRecipe(base, ingredient, output);
            }
        }
    }
}

