/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.CraftingRecipeFiller;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.MapExtendingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class MapExtendingRecipeFiller
implements CraftingRecipeFiller<MapExtendingRecipe> {
    @Override
    public Collection<Display> apply(RecipeHolder<MapExtendingRecipe> recipe) {
        ArrayList<Display> displays = new ArrayList<Display>();
        for (int i = 0; i < 4; ++i) {
            EntryIngredient[] inputs = new EntryIngredient[9];
            for (int j = 0; j < 9; ++j) {
                inputs[j] = j == 4 ? MapExtendingRecipeFiller.mapWith("X", i, 1) : EntryIngredients.of((ItemLike)Items.PAPER);
            }
            displays.add(new DefaultCustomDisplay(recipe, List.of(inputs), List.of(MapExtendingRecipeFiller.mapWith("X", i + 1, 1))));
        }
        return displays;
    }

    @Override
    public Class<MapExtendingRecipe> getRecipeClass() {
        return MapExtendingRecipe.class;
    }

    public static EntryIngredient mapWith(String mapId, int scale, int count) {
        EntryIngredient stacks = EntryIngredients.of((ItemLike)Items.FILLED_MAP, count);
        String unknown = I18n.get((String)"filled_map.unknown", (Object[])new Object[0]);
        for (EntryStack stack : stacks) {
            stack.tooltipProcessor(($, tooltip) -> {
                tooltip.entries().removeIf(entry -> entry.isText() && entry.getAsText().getString().equals(unknown));
                return tooltip;
            });
            stack.tooltip(new Component[]{Component.translatable((String)"filled_map.id", (Object[])new Object[]{mapId}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"filled_map.scale", (Object[])new Object[]{1 << scale}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"filled_map.level", (Object[])new Object[]{scale, 4}).withStyle(ChatFormatting.GRAY)});
        }
        return stacks;
    }
}

