/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.impl.common.util.InstanceHelper;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public class RecipeManagerContextImpl<P extends REIPlugin<?>>
implements RecipeManagerContext<P> {
    private static final Comparator<RecipeHolder<?>> RECIPE_COMPARATOR = Comparator.comparing(o -> o.id().getNamespace()).thenComparing(o -> o.id().getPath());
    private List<RecipeHolder<?>> sortedRecipes = null;

    @Override
    public List<RecipeHolder<?>> getAllSortedRecipes() {
        if (this.sortedRecipes == null) {
            this.sortedRecipes = this.getRecipeManager().getRecipes().parallelStream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.sortedRecipes);
    }

    @Override
    public RecipeManager getRecipeManager() {
        return InstanceHelper.getInstance().recipeManager();
    }

    @Override
    public void startReload() {
        this.sortedRecipes = null;
    }
}

