/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.util;

import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.impl.client.gui.widget.CatchingExceptionUtils;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class CrashReportUtils {
    public static CrashReport essential(Throwable throwable, String task) {
        Throwable temp = throwable;
        while (temp != null) {
            if (!((temp = temp.getCause()) instanceof ReportedException)) continue;
            return CrashReportUtils.essential(temp, task);
        }
        CrashReport report = CrashReport.forThrowable((Throwable)throwable, (String)task);
        CrashReportUtils.screen(report, Minecraft.getInstance().screen);
        return report;
    }

    private static void screen(CrashReport report, Screen screen) {
        if (screen != null) {
            CrashReportCategory category = report.addCategory("Screen details");
            String screenName = screen.getClass().getCanonicalName();
            category.setDetail("Screen name", () -> screenName);
        }
    }

    public static void renderer(CrashReport report, Renderer renderer) {
        if (renderer != null) {
            CrashReportCategory category = report.addCategory("Renderer details");
            try {
                renderer.fillCrashReport(report, category);
            }
            catch (Throwable throwable) {
                category.setDetailError("Filling Report", throwable);
            }
        }
    }

    public static ReportedException throwReport(CrashReport report) {
        return new ReportedException(report);
    }

    public static void catchReport(CrashReport report) {
        CatchingExceptionUtils.handleThrowable((Throwable)new ReportedException(report), report.getTitle());
    }
}

