/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.resources.ResourceLocation;

public class DisplayKey {
    private static final Map<String, DisplayKey> VALUES = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private final CategoryIdentifier<?> categoryIdentifier;
    private final ResourceLocation location;

    public static DisplayKey create(CategoryIdentifier<?> categoryIdentifier, ResourceLocation location) {
        String string = (String.valueOf(categoryIdentifier) + ":" + String.valueOf(location)).intern();
        return VALUES.computeIfAbsent(string, $ -> new DisplayKey(categoryIdentifier, location));
    }

    private DisplayKey(CategoryIdentifier<?> categoryIdentifier, ResourceLocation location) {
        this.categoryIdentifier = categoryIdentifier;
        this.location = location;
    }

    public String toString() {
        return "DisplayKey[" + String.valueOf(this.categoryIdentifier) + " / " + String.valueOf(this.location) + "]";
    }

    public CategoryIdentifier<?> categoryIdentifier() {
        return this.categoryIdentifier;
    }

    public ResourceLocation location() {
        return this.location;
    }
}

