/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListSearchManager;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionRenderingDebugger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class EntryListWidget
extends WidgetWithBounds
implements OverlayListWidget,
DraggableStackVisitorWidget {
    private static final int SIZE = 18;
    protected final RegionRenderingDebugger debugger = new RegionRenderingDebugger();
    protected Rectangle bounds;
    protected Rectangle innerBounds;
    public final NumberAnimator<Double> scaleIndicator = ValueAnimator.ofDouble((double)0.0).withConvention(() -> 0.0, 8000L);

    public static int entrySize() {
        return Mth.ceil((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    public static boolean notSteppingOnExclusionZones(int left, int top, int width, int height) {
        Minecraft instance = Minecraft.getInstance();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.screen)) {
            InteractionResult fit = EntryListWidget.canItemSlotWidgetFit(left, top, width, height, decider);
            if (fit == InteractionResult.PASS) continue;
            return fit == InteractionResult.SUCCESS;
        }
        return true;
    }

    private static InteractionResult canItemSlotWidgetFit(int left, int top, int width, int height, OverlayDecider decider) {
        InteractionResult fit = decider.isInZone(left, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left, top + height);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top + height);
        return fit;
    }

    private boolean containsChecked(Point point, boolean inner) {
        return this.containsChecked(point.x, point.y, inner);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && super.containsMouse(mouseX, mouseY);
    }

    public boolean innerContainsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && this.innerBounds.contains(mouseX, mouseY);
    }

    public boolean containsChecked(double x, double y, boolean inner) {
        if (inner ? !this.innerContainsMouse(x, y) : !this.containsMouse(x, y)) {
            return false;
        }
        Minecraft instance = Minecraft.getInstance();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.screen)) {
            InteractionResult result = decider.isInZone(x, y);
            if (result == InteractionResult.PASS) continue;
            return result == InteractionResult.SUCCESS;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        bounds = bounds.clone();
        int heightReduction = (int)Math.round((double)bounds.height * (1.0 - ConfigObject.getInstance().getVerticalEntriesBoundariesPercentage()));
        bounds.y += (int)Math.round((double)heightReduction * ConfigObject.getInstance().getVerticalEntriesBoundariesAlignments());
        bounds.height -= heightReduction;
        int maxHeight = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getVerticalEntriesBoundariesRows() + (double)EntryListWidget.entrySize() * 0.75);
        if (bounds.height > maxHeight) {
            bounds.y += (int)Math.round((double)(bounds.height - maxHeight) * ConfigObject.getInstance().getVerticalEntriesBoundariesAlignments());
            bounds.height = maxHeight;
        }
        int entrySize = EntryListWidget.entrySize();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(Mth.floor((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        int width = Math.max(Mth.floor((float)((float)(bounds.width - 2) / (float)entrySize)), 1);
        int height = Math.max(Mth.floor((float)((float)(bounds.height - 2) / (float)entrySize)), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)entrySize / 2.0f)), width * entrySize, height * entrySize);
    }

    @Override
    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
        if (this.innerBounds.contains(context.getCurrentPosition())) {
            context.renderToVoid(stack);
            return DraggedAcceptorResult.CONSUMED;
        }
        return DraggedAcceptorResult.PASS;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.containsChecked(mouseX, mouseY, false) && amountY != 0.0 && Screen.hasControlDown()) {
            ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
            this.scaleIndicator.setAs(10.0);
            if (config.setEntrySize(config.getEntrySize() + (double)Double.compare(amountY, 0.0) * 0.05)) {
                ConfigManager.getInstance().saveConfig();
                REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (!this.hasSpace()) {
            return;
        }
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        this.renderEntries(fastEntryRendering, graphics, mouseX, mouseY, delta);
        this.debugger.render(graphics, this.bounds.x, this.bounds.y, delta);
        if (this.containsChecked(mouseX, mouseY, false) && ClientHelper.getInstance().isCheating() && !(Minecraft.getInstance().screen instanceof DisplayScreen) && !this.minecraft.player.containerMenu.getCarried().isEmpty() && ClientHelperImpl.getInstance().canDeleteItems()) {
            EntryStack<ItemStack> stack = EntryStacks.of(this.minecraft.player.containerMenu.getCarried().copy());
            if (stack.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<ItemStack> cheatsAs = stack.cheatsAs();
                stack = cheatsAs.isEmpty() ? stack : cheatsAs;
            }
            for (Widget widget : this.children()) {
                EntryWidget widget2;
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack)) continue;
                return;
            }
            Tooltip.create(new Component[]{Component.translatable((String)"text.rei.delete_items")}).queue();
        }
        this.scaleIndicator.update((double)delta);
        if ((Double)this.scaleIndicator.value() > 0.04) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 500.0f);
            MutableComponent component = Component.literal((String)(Math.round(ConfigObject.getInstance().getEntrySize() * 100.0) + "%"));
            int width = this.font.width((FormattedText)component);
            int n = (int)Math.round(160.0 * Mth.clamp((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            int textColor = (int)Math.round(221.0 * Mth.clamp((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            graphics.fillGradient(this.bounds.getCenterX() - width / 2 - 2, this.bounds.getCenterY() - 6, this.bounds.getCenterX() + width / 2 + 2, this.bounds.getCenterY() + 6, n, n);
            graphics.drawString(this.font, (Component)component, this.bounds.getCenterX() - width / 2, this.bounds.getCenterY() - 4, 0xFFFFFF | textColor, false);
            graphics.pose().popPose();
        }
    }

    protected abstract void renderEntries(boolean var1, GuiGraphics var2, int var3, int var4, float var5);

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.containsChecked(EntryListWidget.mouse(), false)) {
            for (Widget widget : this.getEntryWidgets()) {
                if (!widget.keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(Rectangle bounds, String searchTerm) {
        this.bounds = REIRuntime.getInstance().calculateEntryListArea(bounds);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && favoritesListWidget == null) {
            this.updateSearch(searchTerm, true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean hasSpace() {
        int height;
        int entrySize = EntryListWidget.entrySize();
        int width = this.innerBounds.width / entrySize;
        return width * (height = this.innerBounds.height / entrySize) > 0;
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        boolean zoomed = ConfigObject.getInstance().isFocusModeZoomed();
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        this.updateEntries(entrySize, zoomed);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.getSystemRegion().updateEntriesPosition(entry -> true);
            favoritesListWidget.getRegion().updateEntriesPosition(entry -> true);
        }
    }

    protected abstract void updateEntries(int var1, boolean var2);

    public abstract boolean isEmpty();

    protected abstract void setCollapsedStacks(List<Object> var1);

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        EntryListSearchManager.INSTANCE.update(searchTerm, ignoreLastSearch, stacks -> {
            this.setCollapsedStacks((List<Object>)stacks);
            this.updateEntriesPosition();
        });
        this.debugger.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
        if (favorites != null) {
            favorites.updateSearch();
        }
    }

    public List<? extends Widget> children() {
        return this.getEntryWidgets();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.hasSpace()) {
            return false;
        }
        for (Widget widget : this.children()) {
            if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.containsChecked(mouseX, mouseY, false)) {
            LocalPlayer player = this.minecraft.player;
            if (ClientHelper.getInstance().isCheating() && !(Minecraft.getInstance().screen instanceof DisplayScreen) && player != null && player.containerMenu != null && !player.containerMenu.getCarried().isEmpty() && ClientHelperImpl.getInstance().canDeleteItems()) {
                boolean bl;
                EntryStack<ItemStack> stack = EntryStacks.of(this.minecraft.player.containerMenu.getCarried().copy());
                if (stack.getType() != VanillaEntryTypes.ITEM) {
                    EntryStack<ItemStack> entryStack = stack.cheatsAs();
                    stack = entryStack.isEmpty() ? stack : entryStack;
                }
                boolean bl2 = true;
                for (Widget widget : this.children()) {
                    EntryWidget widget2;
                    if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    ClientHelper.getInstance().sendDeletePacket();
                    return true;
                }
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseReleased(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        Point mouse = EntryListWidget.mouse();
        if (this.containsChecked(mouse, false)) {
            for (Slot slot : this.getEntryWidgets()) {
                EntryStack<?> currentEntry = slot.getCurrentEntry();
                if (currentEntry.isEmpty() || !slot.containsMouse(mouse)) continue;
                return currentEntry.copy();
            }
        }
        return EntryStack.empty();
    }

    protected abstract List<EntryListStackEntry> getEntryWidgets();

    public void init(ScreenOverlayImpl overlay) {
    }
}

