/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.config.RecipeBorderType;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public final class PanelWidget
extends Panel {
    private static final PanelWidget TEMP = new PanelWidget(new Rectangle());
    private Rectangle bounds;
    private int color = -1;
    private int xTextureOffset = 0;
    private int yTextureOffset = RecipeBorderType.DEFAULT.getYOffset();
    private Predicate<Panel> rendering = Predicates.alwaysTrue();
    private NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public static boolean isRendering(Panel panel) {
        return true;
    }

    public PanelWidget(Rectangle bounds) {
        this.bounds = Objects.requireNonNull(bounds);
    }

    @Override
    public int getXTextureOffset() {
        return this.xTextureOffset;
    }

    @Override
    public void setXTextureOffset(int xTextureOffset) {
        this.xTextureOffset = xTextureOffset;
    }

    @Override
    public int getYTextureOffset() {
        return this.yTextureOffset;
    }

    @Override
    public void setYTextureOffset(int yTextureOffset) {
        this.yTextureOffset = yTextureOffset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public Predicate<Panel> getRendering() {
        return this.rendering;
    }

    @Override
    public void setRendering(Predicate<Panel> rendering) {
        this.rendering = Objects.requireNonNull(rendering);
    }

    @ApiStatus.Internal
    public void setDarkBackgroundAlpha(NumberAnimator<Float> darkBackgroundAlpha) {
        this.darkBackgroundAlpha = darkBackgroundAlpha;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        if (ConfigUtils.isReducedMotion()) {
            this.darkBackgroundAlpha.completeImmediately();
        }
        if (!this.getRendering().test(this)) {
            return;
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderBackground(graphics, x, y, width, height, false, alpha, red, green, blue);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha > 0.0f) {
            this.renderBackground(graphics, x, y, width, height, true, ((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha, red, green, blue);
        }
    }

    public void renderBackground(GuiGraphics graphics, int x, int y, int width, int height, boolean dark, float alpha, float red, float green, float blue) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        int xTextureOffset = this.getXTextureOffset();
        int yTextureOffset = this.getYTextureOffset();
        ResourceLocation texture = dark ? InternalTextures.CHEST_GUI_TEXTURE_DARK : InternalTextures.CHEST_GUI_TEXTURE;
        graphics.blit(texture, x, y, 106 + xTextureOffset, 124 + yTextureOffset, 8, 8);
        graphics.blit(texture, x + width - 8, y, 248 + xTextureOffset, 124 + yTextureOffset, 8, 8);
        graphics.blit(texture, x, y + height - 8, 106 + xTextureOffset, 182 + yTextureOffset, 8, 8);
        graphics.blit(texture, x + width - 8, y + height - 8, 248 + xTextureOffset, 182 + yTextureOffset, 8, 8);
        graphics.innerBlit(texture, x + 8, x + width - 8, y, y + 8, 0, (float)(114 + xTextureOffset) / 256.0f, (float)(248 + xTextureOffset) / 256.0f, (float)(124 + yTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f);
        graphics.innerBlit(texture, x + 8, x + width - 8, y + height - 8, y + height, 0, (float)(114 + xTextureOffset) / 256.0f, (float)(248 + xTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f, (float)(190 + yTextureOffset) / 256.0f);
        graphics.innerBlit(texture, x, x + 8, y + 8, y + height - 8, 0, (float)(106 + xTextureOffset) / 256.0f, (float)(114 + xTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f);
        graphics.innerBlit(texture, x + width - 8, x + width, y + 8, y + height - 8, 0, (float)(248 + xTextureOffset) / 256.0f, (float)(256 + xTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f);
        graphics.innerBlit(texture, x + 8, x + width - 8, y + 8, y + height - 8, 0, (float)(114 + xTextureOffset) / 256.0f, (float)(248 + xTextureOffset) / 256.0f, (float)(132 + yTextureOffset) / 256.0f, (float)(182 + yTextureOffset) / 256.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

