/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class MergedWidget
extends Widget {
    private final List<Widget> widgets;

    public MergedWidget(Widget widget1, Widget widget2) {
        this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
    }

    public MergedWidget(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.render(graphics, mouseX, mouseY, delta);
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (Widget widget : this.widgets) {
            if (!widget.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char character, int modifiers) {
        for (Widget widget : this.widgets) {
            if (!widget.charTyped(character, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getZRenderingPriority() {
        return CollectionUtils.max(this.widgets, Comparator.comparingDouble(Widget::getZRenderingPriority)).map(Widget::getZRenderingPriority).orElse(0.0);
    }
}

