/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class AutoCraftingEvaluator {
    public static AutoCraftingResult evaluateAutoCrafting(boolean actuallyCrafting, boolean stackedCrafting, Display display, Supplier<Collection<ResourceLocation>> idsSupplier) {
        AutoCraftingResult result;
        block17: {
            ArrayList<TransferHandler.Result> errors;
            ArrayList<Tooltip.Entry> errorTooltip;
            block16: {
                AbstractContainerScreen<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
                result = new AutoCraftingResult();
                errorTooltip = new ArrayList<Tooltip.Entry>();
                result.tooltipRenderer = (pos, sink) -> {
                    Collection locations;
                    ArrayList<Tooltip.Entry> str = new ArrayList<Tooltip.Entry>(errorTooltip);
                    if (ConfigObject.getInstance().isFavoritesEnabled()) {
                        str.add(Tooltip.entry((Component)Component.literal((String)" ")));
                        str.add(Tooltip.entry((Component)Component.translatable((String)"text.rei.save.recipes", (Object[])new Object[]{Component.literal((String)ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString().toUpperCase(Locale.ROOT)).withStyle(ChatFormatting.BOLD)}).withStyle(ChatFormatting.GRAY)));
                    }
                    if (Minecraft.getInstance().options.advancedItemTooltips && idsSupplier != null && !(locations = (Collection)idsSupplier.get()).isEmpty()) {
                        str.add(Tooltip.entry((Component)Component.literal((String)" ")));
                        for (ResourceLocation location : locations) {
                            String t = I18n.get((String)"text.rei.recipe_id", (Object[])new Object[]{"", location.toString()});
                            if (t.startsWith("\n")) {
                                t = t.substring("\n".length());
                            }
                            str.add(Tooltip.entry((Component)Component.literal((String)t).withStyle(ChatFormatting.GRAY)));
                        }
                    }
                    sink.accept(Tooltip.from(pos, str));
                };
                if (containerScreen == null) {
                    errorTooltip.add(Tooltip.entry((Component)Component.translatable((String)"error.rei.not.supported.move.items").withStyle(ChatFormatting.RED)));
                    return result;
                }
                errors = new ArrayList<TransferHandler.Result>();
                TransferHandler.Result successfulResult = null;
                TransferHandler.Context context = TransferHandler.Context.create(actuallyCrafting, stackedCrafting, containerScreen, display);
                for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
                    try {
                        TransferHandler.ApplicabilityResult applicabilityResult = transferHandler.checkApplicable(context);
                        if (!applicabilityResult.isApplicable()) continue;
                        TransferHandler.Result transferResult = applicabilityResult.isSuccessful() ? transferHandler.handle(context) : applicabilityResult.getError();
                        if (transferResult.isBlocking() && actuallyCrafting) {
                            if (!transferResult.isReturningToScreen()) break;
                            Minecraft.getInstance().setScreen(containerScreen);
                            REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                            break;
                        }
                        if (!transferResult.isApplicable()) continue;
                        result.hasApplicable = true;
                        result.tint = transferResult.getColor();
                        TransferHandlerRenderer transferHandlerRenderer = transferResult.getRenderer(transferHandler, context);
                        if (transferHandlerRenderer != null) {
                            result.renderer = transferHandlerRenderer;
                        }
                        if (transferResult.getTooltipRenderer() != null) {
                            BiConsumer<Point, TransferHandler.Result.TooltipSink> tooltipRenderer = transferResult.getTooltipRenderer();
                            result.tooltipRenderer = (point, tooltipConsumer) -> tooltipRenderer.accept((Point)point, tooltipConsumer::accept);
                        }
                        if (transferResult.isSuccessful()) {
                            errors.clear();
                            successfulResult = transferResult;
                            result.successful = true;
                            result.successfulHandler = transferHandler;
                            break;
                        }
                        errors.add(transferResult);
                        if (!transferResult.isBlocking()) continue;
                        break;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (!result.hasApplicable) {
                    errorTooltip.clear();
                    errorTooltip.add(Tooltip.entry((Component)Component.translatable((String)"error.rei.not.supported.move.items").withStyle(ChatFormatting.RED)));
                    return result;
                }
                if (!errors.isEmpty()) break block16;
                errorTooltip.clear();
                errorTooltip.add(Tooltip.entry((Component)Component.translatable((String)"text.auto_craft.move_items")));
                if (successfulResult == null) break block17;
                successfulResult.fillTooltip(errorTooltip);
                break block17;
            }
            errorTooltip.clear();
            ArrayList<Tooltip.Entry> tooltipsFilled = new ArrayList<Tooltip.Entry>();
            for (TransferHandler.Result error : errors) {
                error.fillTooltip(tooltipsFilled);
            }
            if (errors.size() == 1) {
                for (Tooltip.Entry tooltipFilled : tooltipsFilled) {
                    if (tooltipFilled.isText()) {
                        colored = tooltipFilled.getAsText().copy().withStyle(ChatFormatting.RED);
                        if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.isText() && ss.getAsText().getString().equalsIgnoreCase(colored.getString()))) continue;
                        errorTooltip.add(Tooltip.entry((Component)colored));
                        continue;
                    }
                    errorTooltip.add(tooltipFilled);
                }
            } else {
                errorTooltip.add(Tooltip.entry((Component)Component.translatable((String)"error.rei.multi.errors").withStyle(ChatFormatting.RED)));
                for (Tooltip.Entry tooltipFilled : tooltipsFilled) {
                    if (tooltipFilled.isText()) {
                        colored = Component.literal((String)"- ").withStyle(ChatFormatting.RED).append((Component)tooltipFilled.getAsText().copy().withStyle(ChatFormatting.RED));
                        if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.isText() && ss.getAsText().getString().equalsIgnoreCase(colored.getString()))) continue;
                        errorTooltip.add(Tooltip.entry((Component)colored));
                        continue;
                    }
                    errorTooltip.add(tooltipFilled);
                }
            }
        }
        return result;
    }

    public static class AutoCraftingResult {
        public int tint = 0;
        public boolean successful = false;
        public TransferHandler successfulHandler;
        public boolean hasApplicable = false;
        public TransferHandlerRenderer renderer;
        public BiConsumer<Point, Consumer<Tooltip>> tooltipRenderer;
    }
}

