/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.CollapsibleEntryWidget;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.selection.CustomCollapsibleEntrySelectionScreen;
import me.shedaniel.rei.impl.client.gui.screen.generic.OptionEntriesScreen;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class CollapsibleEntriesScreen
extends Screen {
    private final Runnable onClose;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final List<CollapsibleEntryWidget> widgets = new ArrayList<CollapsibleEntryWidget>();
    private ListWidget listWidget;
    private boolean dirty = true;

    public CollapsibleEntriesScreen(Runnable onClose, CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        super((Component)Component.translatable((String)"text.rei.collapsible.entries.title"));
        this.onClose = onClose;
        this.configObject = configObject;
        this.prepareWidgets(configObject);
    }

    public void prepareWidgets(CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        this.widgets.clear();
        for (CollapsibleConfigManager.CustomGroup customEntry : configObject.customGroups) {
            this.widgets.add(new CollapsibleEntryWidget(true, customEntry.id, (Component)Component.literal((String)customEntry.name), CollectionUtils.filterAndMap(customEntry.stacks, EntryStackProvider::isValid, EntryStackProvider::provide), configObject, () -> {
                this.prepareWidgets(configObject);
                this.dirty = true;
            }));
        }
        CollapsibleEntryRegistryImpl collapsibleRegistry = (CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance();
        ListMultimap entries = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        for (HashedEntryStackWrapper hashedEntryStackWrapper : ((EntryRegistryImpl)EntryRegistry.getInstance()).getFilteredList().getList()) {
            for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
                if (!entry.getMatcher().matches(hashedEntryStackWrapper.unwrap(), hashedEntryStackWrapper.hashExact())) continue;
                entries.put((Object)entry.getId(), hashedEntryStackWrapper.unwrap());
            }
        }
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
            this.widgets.add(new CollapsibleEntryWidget(false, entry.getId(), entry.getName(), entries.get((Object)entry.getId()), configObject, () -> {
                this.prepareWidgets(configObject);
                this.dirty = true;
            }));
        }
    }

    public void init() {
        super.init();
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.addRenderableWidget((GuiEventListener)new Button(this, 4, 4, this.font.width((FormattedText)backText) + 10, 20, (Component)backText, button -> this.onClose(), Supplier::get){});
        MutableComponent addText = Component.literal((String)" + ");
        this.addRenderableWidget((GuiEventListener)new Button(this, this.width - 4 - 20, 4, 20, 20, (Component)addText, $ -> CollapsibleEntriesScreen.setupCustom(ResourceLocation.parse((String)("custom:" + String.valueOf(UUID.randomUUID()))), "", new ArrayList(), this.configObject, () -> {
            this.prepareWidgets(this.configObject);
            this.dirty = true;
        }), Supplier::get){});
        this.listWidget = new ListWidget(this.width, this.height, 30);
        this.children().add(this.listWidget);
        this.dirty = true;
    }

    public static void setupCustom(final ResourceLocation id, final String name, final List<EntryStack<?>> stacks, final CollapsibleConfigManager.CollapsibleConfigObject configObject, final Runnable markDirty) {
        Minecraft.getInstance().setScreen((Screen)new OptionEntriesScreen((Component)Component.translatable((String)"text.rei.collapsible.entries.custom.title"), Minecraft.getInstance().screen){
            private OptionEntriesScreen.TextFieldListEntry entry;

            @Override
            public void addEntries(Consumer<OptionEntriesScreen.ListEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)Component.translatable((String)"text.rei.collapsible.entries.custom.id").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(" " + String.valueOf(id))).withStyle(ChatFormatting.DARK_GRAY)));
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)Component.translatable((String)"text.rei.collapsible.entries.custom.name").withStyle(ChatFormatting.GRAY));
                this.entry = new OptionEntriesScreen.TextFieldListEntry(this.width - 36, widget -> {
                    widget.setMaxLength(40);
                    if (this.entry != null) {
                        widget.setValue(this.entry.getWidget().getValue());
                    } else {
                        widget.setValue(name);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                entryConsumer.accept(new OptionEntriesScreen.ButtonListEntry(this.width - 36, $ -> Component.translatable((String)"text.rei.collapsible.entries.custom.select"), ($, button) -> {
                    CustomCollapsibleEntrySelectionScreen screen = new CustomCollapsibleEntrySelectionScreen(stacks);
                    screen.parent = this.minecraft.screen;
                    this.minecraft.setScreen((Screen)screen);
                }));
            }

            @Override
            public void save() {
                configObject.customGroups.removeIf(customGroup -> customGroup.id.equals((Object)id));
                configObject.customGroups.add(new CollapsibleConfigManager.CustomGroup(id, this.entry.getWidget().getValue(), CollectionUtils.map(stacks, EntryStackProvider::ofStack)));
                markDirty.run();
            }
        });
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.dirty) {
            this.listWidget.clear();
            for (CollapsibleEntryWidget widget : this.widgets) {
                this.listWidget.add(widget);
            }
            this.dirty = false;
        }
        super.render(graphics, mouseX, mouseY, delta);
        this.listWidget.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, 12, -1);
        if (ConfigObject.getInstance().doDebugRenderTimeRequired()) {
            MutableComponent debugText = Component.literal((String)String.format("%s fps", this.minecraft.fpsString.split(" ")[0]));
            int stringWidth = this.font.width((FormattedText)debugText);
            int n = this.minecraft.screen.width - stringWidth - 2;
            int n2 = this.minecraft.screen.width;
            Objects.requireNonNull(this.font);
            graphics.fillGradient(n, 32, n2, 32 + 9 + 2, -16777216, -16777216);
            graphics.pose().pushPose();
            Matrix4f matrix = graphics.pose().last().pose();
            this.font.drawInBatch(debugText.getVisualOrderText(), (float)(this.minecraft.screen.width - stringWidth), 34.0f, -1, false, matrix, (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            graphics.flush();
            graphics.pose().popPose();
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(graphics, mouseX, mouseY, delta);
        UpdatedListWidget.renderAs(this.minecraft, this.width, this.height, this.listWidget.top, this.height, graphics, delta);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        return this.listWidget.mouseScrolled(mouseX, mouseY, amountX, amountY) || super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.listWidget.mouseClicked(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.listWidget.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void onClose() {
        this.onClose.run();
    }

    private static class ListWidget
    extends Widget {
        private static final int PADDING = 6;
        private final int width;
        private final int height;
        private final int top;
        private final ScrollingContainer scroller = new ScrollingContainer(){

            public Rectangle getBounds() {
                return new Rectangle(0, top, width, height - top);
            }

            public int getMaxScrollHeight() {
                return this.getMaxScrollDist();
            }
        };
        private final List<CollapsibleEntryWidget>[] columns;
        private final List<CollapsibleEntryWidget> children = new ArrayList<CollapsibleEntryWidget>();

        public ListWidget(int width, int height, int top) {
            this.width = width;
            this.height = height;
            this.top = top;
            this.columns = new List[Math.max(1, (width - 12 - 6) / 136)];
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i] = new ArrayList<CollapsibleEntryWidget>();
            }
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.scroller.updatePosition(delta);
            try (CloseableScissors scissors = ListWidget.scissor(graphics, new Rectangle(0, this.top, this.width - 6, this.height - this.top));){
                int entryWidth = (this.width - 12 - 6 - 6) / this.columns.length - 6;
                for (int i = 0; i < this.columns.length; ++i) {
                    int x = 12 + i * (entryWidth + 6);
                    int y = this.top + 6 - this.scroller.scrollAmountInt();
                    for (CollapsibleEntryWidget widget : this.columns[i]) {
                        widget.setPosition(x, y);
                        widget.setWidth(entryWidth);
                        widget.render(graphics, mouseX, mouseY, delta);
                        y += widget.getHeight() + 6;
                    }
                }
            }
            this.scroller.renderScrollBar(graphics);
            ScreenOverlayImpl.getInstance().lateRender(graphics, mouseX, mouseY, delta);
        }

        private int getMaxScrollDist() {
            return Arrays.stream(this.columns).mapToInt(ListWidget::getHeightOf).max().orElse(0) + 12;
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
            for (CollapsibleEntryWidget widget : this.children) {
                if (!widget.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
                return true;
            }
            if (mouseY > (double)this.top && amountY != 0.0) {
                this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                return true;
            }
            return false;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.scroller.updateDraggingState(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.scroller.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public void clear() {
            this.children.clear();
            for (List<CollapsibleEntryWidget> column : this.columns) {
                column.clear();
            }
        }

        public void add(CollapsibleEntryWidget widget) {
            Arrays.stream(this.columns).min(Comparator.comparingInt(ListWidget::getHeightOf)).ifPresent(widgets -> widgets.add(widget));
            this.children.add(widget);
        }

        private static int getHeightOf(List<CollapsibleEntryWidget> widgets) {
            int height = 0;
            for (CollapsibleEntryWidget w : widgets) {
                height += w.getHeight() + 6;
            }
            return Math.max(0, height - 6);
        }
    }
}

