/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UncertainDisplayViewingScreen
extends Screen {
    private static final ResourceLocation DEFAULT = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/screenshot_default.png");
    private static final ResourceLocation COMPOSITE = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/screenshot_composite.png");
    private final List<Widget> widgets = Lists.newArrayList();
    protected long start;
    protected long duration;
    private boolean isSet;
    private boolean original;
    private double frame = 0.0;
    private double target = 0.0;
    private BooleanConsumer callback;
    private Button button;
    private Screen parent;
    private boolean showTips;

    public UncertainDisplayViewingScreen(Screen parent, DisplayScreenType type, boolean showTips, BooleanConsumer callback) {
        super((Component)Component.empty());
        if (type == DisplayScreenType.UNSET) {
            this.isSet = false;
            this.original = true;
        } else {
            this.isSet = true;
            this.original = type == DisplayScreenType.ORIGINAL;
            this.moveFrameTo(this.original ? 0.0 : 1.0, false, 0L);
        }
        this.callback = callback;
        this.parent = parent;
        this.showTips = showTips;
    }

    public final double clamp(double v) {
        return this.clamp(v, 30.0);
    }

    public final double clamp(double v, double clampExtension) {
        return Mth.clamp((double)v, (double)(-clampExtension), (double)(1.0 + clampExtension));
    }

    private void moveFrameTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.frame = this.target;
        }
    }

    public void init() {
        this.children().clear();
        this.widgets.clear();
        this.button = Widgets.createButton(new Rectangle(this.width / 2 - 100, this.height - 40, 200, 20), (Component)Component.empty()).onRender((matrices, button) -> {
            button.setEnabled(this.isSet);
            button.setText((Component)Component.translatable((String)"gui.done"));
        }).onClick(button -> this.callback.accept(this.original));
        this._children().add((GuiEventListener)this.button);
        this.widgets.add(new ScreenTypeSelection(this.width / 2 - 200 - 5, this.height / 2 - 56 - 10, DisplayScreenType.ORIGINAL));
        this.widgets.add(Widgets.createLabel(new Point(this.width / 2 - 200 - 5 + 104, this.height / 2 - 56 + 115), (Component)Component.translatable((String)"config.roughlyenoughitems.recipeScreenType.original")).noShadow().color(-1124073473));
        this.widgets.add(new ScreenTypeSelection(this.width / 2 + 5, this.height / 2 - 56 - 10, DisplayScreenType.COMPOSITE));
        this.widgets.add(Widgets.createLabel(new Point(this.width / 2 + 5 + 104, this.height / 2 - 56 + 115), (Component)Component.translatable((String)"config.roughlyenoughitems.recipeScreenType.composite")).noShadow().color(-1124073473));
        this._children().addAll(this.widgets);
    }

    public List<GuiEventListener> _children() {
        return this.children();
    }

    public void render(GuiGraphics graphics, int int_1, int int_2, float float_1) {
        super.render(graphics, int_1, int_2, float_1);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"text.rei.recipe_screen_type.selection"), this.width / 2, 20, 0xFFFFFF);
        Objects.requireNonNull(this.font);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(0, 20 + 9 + 2, this.width, this.height - 42));
        if (this.showTips) {
            int i = 32;
            for (FormattedCharSequence s : this.font.split((FormattedText)Component.translatable((String)"text.rei.recipe_screen_type.selection.sub").withStyle(ChatFormatting.GRAY), this.width - 30)) {
                graphics.drawString(this.font, s, this.width / 2 - this.font.width(s) / 2, i, -1);
                i += 10;
            }
        }
        int k = 10;
        int l = 44;
        int m = this.width - 20;
        int n = this.height - l - 10 - 5;
        graphics.fill(k + 1, l, k + m, l + n, -16777216);
        graphics.renderOutline(k, l, m, n, -1);
        for (Widget widget : this.widgets) {
            widget.render(graphics, int_1, int_2, float_1);
        }
        if (this.isSet) {
            graphics.pose().pushPose();
            this.updateFramePosition(float_1);
            int x = (int)((double)(this.width / 2 - 205) + 200.0 * this.frame) + 10;
            int y = this.height / 2 - 56 - 10;
            graphics.fillGradient(x - 2, y - 4, x - 6 + 208 - 10, y - 4 + 2, -1778384897, -1778384897);
            graphics.fillGradient(x - 2, y - 4 + 126 - 2, x - 6 + 208 - 10, y - 4 + 126, -1778384897, -1778384897);
            graphics.fillGradient(x - 4, y - 4, x - 4 + 2, y - 4 + 126, -1778384897, -1778384897);
            graphics.fillGradient(x - 4 + 208 - 2 - 10, y - 4, x - 4 + 208 - 10, y - 4 + 126, -1778384897, -1778384897);
            graphics.pose().popPose();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.button.render(graphics, int_1, int_2, float_1);
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
        super.renderBackground(graphics, i, j, f);
    }

    private void updateFramePosition(float delta) {
        this.target = this.clamp(this.target);
        this.frame = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.frame, (double)this.target, (double)0.001f) ? this.ease(this.frame, this.target, Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration * (double)delta * 3.0, 1.0)) : this.target;
    }

    private double ease(double start, double end, double amount) {
        return start + (end - start) * EasingMethod.EasingMethodImpl.LINEAR.apply(amount);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 || this.minecraft.options.keyInventory.matches(int_1, int_2)) {
            Minecraft.getInstance().setScreen(this.parent);
            if (this.parent instanceof AbstractContainerScreen) {
                REIRuntime.getInstance().getOverlay().get().queueReloadOverlay();
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public class ScreenTypeSelection
    extends WidgetWithBounds {
        private final DisplayScreenType type;
        private Rectangle bounds;

        public ScreenTypeSelection(int x, int y, DisplayScreenType type) {
            this.type = type;
            this.bounds = new Rectangle(x - 4 + 16, y - 4, 184, 128);
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void render(GuiGraphics graphics, int i, int i1, float delta) {
            graphics.blit(this.type == DisplayScreenType.ORIGINAL ? DEFAULT : COMPOSITE, this.bounds.x + (this.type == DisplayScreenType.ORIGINAL ? 8 : 4), this.bounds.y + 4, this.bounds.width - 8, this.bounds.height - 8, 113.0f, this.type == DisplayScreenType.ORIGINAL ? 16.0f : 27.0f, 628, 426, 854, 480);
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (this.containsMouse(double_1, double_2)) {
                boolean bl = UncertainDisplayViewingScreen.this.original = this.type == DisplayScreenType.ORIGINAL;
                if (!UncertainDisplayViewingScreen.this.isSet) {
                    UncertainDisplayViewingScreen.this.moveFrameTo(UncertainDisplayViewingScreen.this.original ? 0.0 : 1.0, false, 0L);
                }
                UncertainDisplayViewingScreen.this.isSet = true;
                UncertainDisplayViewingScreen.this.moveFrameTo(UncertainDisplayViewingScreen.this.original ? 0.0 : 1.0, true, 500L);
                return true;
            }
            return false;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }
    }
}

