/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.impl.client.gui.performance.PerformanceScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SubCategoryListEntry
extends PerformanceScreen.PerformanceEntry
implements Expandable {
    private static final ResourceLocation CONFIG_TEX = ResourceLocation.fromNamespaceAndPath((String)"cloth-config2", (String)"textures/gui/cloth_config.png");
    private final List<PerformanceScreen.PerformanceEntry> entries;
    private final CategoryLabelWidget widget;
    private final List<GuiEventListener> children;
    private final Component name;
    private final long totalTime;
    private boolean expanded;

    public SubCategoryListEntry(Component name, List<PerformanceScreen.PerformanceEntry> entries, long totalTime, boolean defaultExpanded) {
        this.name = name;
        this.entries = entries;
        this.totalTime = totalTime;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new GuiEventListener[]{this.widget});
        this.children.addAll(entries);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.widget.rectangle.x = x + 3;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth - 6;
        this.widget.rectangle.height = 24;
        graphics.blit(CONFIG_TEX, x + 3, y + 5, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        graphics.drawString(Minecraft.getInstance().font, this.name.getVisualOrderText(), x + 3 + 15, y + 6, this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        for (PerformanceScreen.PerformanceEntry performanceEntry : this.entries) {
            performanceEntry.setParent(this.getParent());
        }
        if (this.expanded) {
            int yy = y + 24;
            for (PerformanceScreen.PerformanceEntry entry : this.entries) {
                entry.render(graphics, -1, yy, x + 3 + 15, entryWidth - 15 - 3, entry.getItemHeight(), mouseX, mouseY, isHovered && this.getFocused() == entry, delta);
                yy += entry.getItemHeight();
            }
        }
        FormattedCharSequence timeText = PerformanceScreen.formatTime(this.totalTime, true);
        graphics.drawString(Minecraft.getInstance().font, timeText, x + entryWidth - 6 - 4 - Minecraft.getInstance().font.width(timeText), y + 6, -1);
    }

    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (PerformanceScreen.PerformanceEntry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.widget.rectangle.x = x;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth;
        this.widget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    public int getItemHeight() {
        if (!this.expanded) {
            return 24;
        }
        int i = 24;
        for (PerformanceScreen.PerformanceEntry entry : this.entries) {
            i += entry.getItemHeight();
        }
        return i;
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    public List<? extends NarratableEntry> narratables() {
        return Collections.emptyList();
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public class CategoryLabelWidget
    implements GuiEventListener {
        private final Rectangle rectangle = new Rectangle();

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.rectangle.contains(mouseX, mouseY)) {
                SubCategoryListEntry.this.expanded = !SubCategoryListEntry.this.expanded;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
            return false;
        }

        public void setFocused(boolean bl) {
        }

        public boolean isFocused() {
            return false;
        }
    }
}

