/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CollectionUtils {
    public static <A, B> List<B> getOrPutEmptyList(Map<A, List<B>> map, A key) {
        List<B> b = map.get(key);
        if (b != null) {
            return b;
        }
        map.put(key, new ArrayList());
        return map.get(key);
    }

    public static <T> T findFirstOrNullEquals(Iterable<T> list, T obj) {
        for (T t : list) {
            if (!t.equals(obj)) continue;
            return t;
        }
        return null;
    }

    public static <T, R> List<R> castAndMap(Iterable<T> list, Class<R> castClass) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : list) {
            if (!castClass.isAssignableFrom(t.getClass())) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> T findFirstOrNull(Iterable<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean allMatch(Iterable<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> list, Predicate<T> predicate) {
        return CollectionUtils.findFirstOrNull(list, predicate) != null;
    }

    public static EntryStack<?> findFirstOrNullEqualsExact(Iterable<? extends EntryStack<?>> list, EntryStack<?> stack) {
        for (EntryStack<?> t : list) {
            if (!EntryStacks.equalsExact(t, stack)) continue;
            return t;
        }
        return null;
    }

    public static <T> List<T> filterToList(Iterable<T> list, Predicate<T> predicate) {
        ArrayList l = Lists.newArrayList();
        for (T t : list) {
            if (!predicate.test(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> Set<T> filterToSet(Iterable<T> list, Predicate<T> predicate) {
        LinkedHashSet l = Sets.newLinkedHashSet();
        for (T t : list) {
            if (!predicate.test(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T, R> List<R> map(Collection<T> list, Function<T, R> function) {
        ArrayList<R> l = new ArrayList<R>(list.size() + 1);
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> List<R> map(Iterable<T> list, Function<T, R> function) {
        ArrayList<R> l = new ArrayList<R>();
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> Set<R> mapToSet(Collection<T> list, Function<T, R> function) {
        HashSet<R> l = new HashSet<R>(list.size() + 1);
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> Set<R> mapToSet(Iterable<T> list, Function<T, R> function) {
        HashSet<R> l = new HashSet<R>();
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> List<R> mapIndexed(Iterable<T> list, IndexedFunction<T, R> function) {
        ArrayList<R> l = list instanceof Collection ? new ArrayList<R>(((Collection)list).size() + 1) : new ArrayList();
        int i = 0;
        for (T t : list) {
            l.add(function.apply(i++, t));
        }
        return l;
    }

    public static <T, R> List<R> flatMap(Iterable<T> list, Function<T, Collection<R>> function) {
        ArrayList<R> l = new ArrayList<R>();
        for (T t : list) {
            l.addAll(function.apply(t));
        }
        return l;
    }

    public static <T, R> List<R> flatMap(T[] list, Function<T, Collection<R>> function) {
        ArrayList<R> l = new ArrayList<R>();
        for (T t : list) {
            l.addAll(function.apply(t));
        }
        return l;
    }

    public static <T> IntList mapToInt(Collection<T> list, ToIntFunction<T> function) {
        IntArrayList l = new IntArrayList(list.size() + 1);
        for (T t : list) {
            l.add(function.applyAsInt(t));
        }
        return l;
    }

    public static <T, R> List<R> mapParallel(Collection<T> list, Function<T, R> function) {
        return list.parallelStream().map(function).collect(Collectors.toList());
    }

    public static <T, R, C extends Collection<R>> C mapParallel(Collection<T> list, Function<T, R> function, Supplier<C> supplier) {
        return (C)((Collection)list.parallelStream().map(function).collect(Collectors.toCollection(supplier)));
    }

    public static <T, R, C extends Collection<R>> C filterAndMapParallel(Collection<T> list, Predicate<T> filter, Function<T, R> function, Supplier<C> supplier) {
        return (C)((Collection)list.parallelStream().filter(filter).map(function).collect(Collectors.toCollection(supplier)));
    }

    public static <T, R> List<R> map(T[] list, Function<T, R> function) {
        ArrayList<R> l = new ArrayList<R>(list.length + 1);
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static <T, R> Optional<R> mapAndMax(Collection<T> list, Function<T, R> function, Comparator<R> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().max(Comparator.comparing(function, comparator)).map(function);
    }

    public static <T, R> Optional<R> mapAndMax(T[] list, Function<T, R> function, Comparator<R> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        return Stream.of(list).max(Comparator.comparing(function, comparator)).map(function);
    }

    public static <T> Optional<T> max(Collection<T> list, Comparator<T> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().max(comparator);
    }

    public static <T> Optional<T> max(T[] list, Comparator<T> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        return Stream.of(list).max(comparator);
    }

    public static <T, R> Optional<R> mapAndMin(Collection<T> list, Function<T, R> function, Comparator<R> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().min(Comparator.comparing(function, comparator)).map(function);
    }

    public static <T, R> Optional<R> mapAndMin(T[] list, Function<T, R> function, Comparator<R> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        return Stream.of(list).min(Comparator.comparing(function, comparator)).map(function);
    }

    public static <T> Optional<T> min(Collection<T> list, Comparator<T> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return list.stream().min(comparator);
    }

    public static <T> Optional<T> min(T[] list, Comparator<T> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        return Stream.of(list).min(comparator);
    }

    public static String joinToString(Iterable<CharSequence> list, CharSequence separator) {
        return String.join(separator, list);
    }

    public static String joinToString(CharSequence[] list, CharSequence separator) {
        return String.join(separator, list);
    }

    public static <T> String mapAndJoinToString(Iterable<T> list, Function<T, CharSequence> function, CharSequence separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public static <T> String mapAndJoinToString(T[] list, Function<T, CharSequence> function, CharSequence separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public static <T> Component mapAndJoinToComponent(Iterable<T> list, Function<T, Component> function, Component separator) {
        MutableComponent joiner = Component.literal((String)"");
        boolean first = true;
        for (T t : list) {
            if (first) {
                first = false;
            } else {
                joiner.append((Component)separator.copy());
            }
            joiner.append(function.apply(t));
        }
        return joiner;
    }

    public static <T> Component mapAndJoinToComponent(T[] list, Function<T, Component> function, Component separator) {
        MutableComponent joiner = Component.literal((String)"");
        boolean first = true;
        for (T t : list) {
            if (first) {
                first = false;
            } else {
                joiner.append((Component)separator.copy());
            }
            joiner.append(function.apply(t));
        }
        return joiner;
    }

    public static <T, R> List<R> filterAndMap(Iterable<T> list, Predicate<T> predicate, Function<T, R> function) {
        ArrayList l = null;
        for (T t : list) {
            if (!predicate.test(t)) continue;
            if (l == null) {
                l = Lists.newArrayList();
            }
            l.add(function.apply(t));
        }
        return l == null ? Collections.emptyList() : l;
    }

    public static <T, R> List<R> mapAndFilter(Iterable<T> list, Predicate<R> predicate, Function<T, R> function) {
        ArrayList l = null;
        for (T t : list) {
            R r = function.apply(t);
            if (!predicate.test(r)) continue;
            if (l == null) {
                l = Lists.newArrayList();
            }
            l.add(r);
        }
        return l == null ? Collections.emptyList() : l;
    }

    public static <T> int sumInt(Iterable<T> list, Function<T, Integer> function) {
        int sum = 0;
        for (T t : list) {
            sum += function.apply(t).intValue();
        }
        return sum;
    }

    public static <T> int sumInt(Iterable<Integer> list) {
        int sum = 0;
        for (int t : list) {
            sum += t;
        }
        return sum;
    }

    public static <T> double sumDouble(Iterable<T> list, Function<T, Double> function) {
        double sum = 0.0;
        for (T t : list) {
            sum += function.apply(t).doubleValue();
        }
        return sum;
    }

    public static <T> double sumDouble(Iterable<Double> list) {
        double sum = 0.0;
        for (double t : list) {
            sum += t;
        }
        return sum;
    }

    public static <T> List<T> distinctToList(Iterable<T> list) {
        ArrayList<T> newList = new ArrayList<T>();
        HashSet<T> set = new HashSet<T>();
        for (T t : list) {
            if (!set.add(t)) continue;
            newList.add(t);
        }
        return newList;
    }

    public static <T> Iterable<List<T>> partition(final List<T> list, final int size) {
        return () -> new UnmodifiableIterator<List<T>>(){
            int i = 0;
            int partitionSize = Mth.ceil((float)((float)list.size() / (float)size));

            public boolean hasNext() {
                return this.i < this.partitionSize;
            }

            public List<T> next() {
                final int cursor = this.i++ * size;
                final int realSize = Math.min(list.size() - cursor, size);
                return new AbstractList<T>(){

                    @Override
                    public T get(int index) {
                        if (index < 0 || index >= realSize) {
                            return null;
                        }
                        return list.get(cursor + index);
                    }

                    @Override
                    public int size() {
                        return realSize;
                    }

                    @Override
                    public Iterator<T> iterator() {
                        final Iterator iterator = super.iterator();
                        return new Iterator<T>(){
                            boolean endReached = false;

                            @Override
                            public boolean hasNext() {
                                return iterator.hasNext() && !this.endReached;
                            }

                            @Override
                            public T next() {
                                try {
                                    return iterator.next();
                                }
                                catch (NoSuchElementException e) {
                                    this.endReached = true;
                                    return null;
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    public static <T> Iterable<Iterator<T>> partitionIterator(final Iterator<T> iterator, final int iteratorSize, int size) {
        return CollectionUtils.partitionCollection(new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }

            @Override
            public int size() {
                return iteratorSize;
            }
        }, size);
    }

    public static <T> Iterable<Iterator<T>> partitionCollection(final Collection<T> collection, final int size) {
        if (collection instanceof List) {
            return Iterables.transform(CollectionUtils.partition((List)collection, size), List::iterator);
        }
        return () -> new Iterator<Iterator<T>>(){
            int i = 0;
            int partitionSize = Mth.ceil((float)((float)collection.size() / (float)size));
            int advanced = 0;
            Iterator<T> iterator = collection.iterator();

            @Override
            public boolean hasNext() {
                return this.i < this.partitionSize;
            }

            @Override
            public Iterator<T> next() {
                final int cursor = this.i++ * size;
                final int realSize = Math.min(collection.size() - cursor, size);
                if (this.advanced < cursor) {
                    for (int j = 0; j < cursor - this.advanced; ++j) {
                        if (!this.iterator.hasNext()) {
                            this.advanced = cursor;
                            return Collections.emptyIterator();
                        }
                        this.iterator.next();
                    }
                    this.advanced = cursor;
                }
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext() && advanced < cursor + realSize;
                    }

                    @Override
                    public T next() {
                        ++advanced;
                        return iterator.next();
                    }
                };
            }
        };
    }

    public static Ingredient toIngredient(ItemStack stack) {
        return Ingredient.of(Stream.of(stack));
    }

    public static Ingredient toIngredient(Iterable<ItemStack> stacks) {
        return Ingredient.of(StreamSupport.stream(stacks.spliterator(), false));
    }

    @SafeVarargs
    public static <T> List<T> concatUnmodifiable(List<? extends T> ... lists) {
        return new ListConcatenationView(Arrays.asList(lists));
    }

    public static <T> List<T> concatUnmodifiable(Iterable<List<? extends T>> lists) {
        return new ListConcatenationView(lists);
    }

    public static <T> Iterable<T> distinctReferenceOf(final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private final Set<T> set = new ReferenceOpenHashSet();
            private final Iterator<T> iterator = iterable.iterator();

            protected T computeNext() {
                while (this.iterator.hasNext()) {
                    Object next = this.iterator.next();
                    if (!this.set.add(next)) continue;
                    return next;
                }
                return this.endOfData();
            }
        };
    }

    @FunctionalInterface
    public static interface IndexedFunction<T, R> {
        public R apply(int var1, T var2);
    }

    private static class ListConcatenationView<E>
    extends AbstractList<E> {
        private final Iterable<List<? extends E>> lists;

        public ListConcatenationView(Iterable<List<? extends E>> lists) {
            this.lists = lists;
        }

        @Override
        public E get(int ix) {
            int localIx = ix;
            for (List<E> l : this.lists) {
                if (localIx < 0) {
                    throw new IndexOutOfBoundsException(ix);
                }
                if (localIx < l.size()) {
                    return l.get(localIx);
                }
                localIx -= l.size();
            }
            return null;
        }

        @Override
        public int size() {
            int size = 0;
            for (List<E> l : this.lists) {
                size += l.size();
            }
            return size;
        }
    }
}

