/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.comparison;

import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

@FunctionalInterface
public interface EntryComparator<T> {
    public static <T> EntryComparator<T> noop() {
        return (context, stack) -> 1L;
    }

    public static EntryComparator<ItemStack> itemComponents() {
        EntryComparator<DataComponentMap> componentHasher = EntryComparator.component(new DataComponentType[0]);
        return (context, stack) -> componentHasher.hash(context, stack.getComponents());
    }

    public static EntryComparator<FluidStack> fluidComponents() {
        EntryComparator<DataComponentMap> componentHasher = EntryComparator.component(new DataComponentType[0]);
        return (context, stack) -> 0L;
    }

    public static EntryComparator<DataComponentMap> component(DataComponentType<?> ... ignoredKeys) {
        return Internals.getComponentHasher(ignoredKeys);
    }

    public long hash(ComparisonContext var1, T var2);

    default public EntryComparator<T> onlyExact() {
        EntryComparator self = this;
        return (context, stack) -> context.isExact() ? self.hash(context, stack) : 1L;
    }

    default public EntryComparator<T> then(EntryComparator<T> other) {
        Objects.requireNonNull(other);
        EntryComparator self = this;
        return (context, stack) -> {
            long hash = 1L;
            hash = hash * 31L + self.hash(context, stack);
            hash = hash * 31L + other.hash(context, stack);
            return hash;
        };
    }
}

