/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.category;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.extension.CategoryExtensionProvider;
import me.shedaniel.rei.api.client.registry.category.visibility.CategoryVisibilityPredicate;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.Identifiable;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public interface CategoryRegistry
extends Reloadable<REIClientPlugin>,
Iterable<CategoryConfiguration<?>> {
    public static CategoryRegistry getInstance() {
        return PluginManager.getClientInstance().get(CategoryRegistry.class);
    }

    default public Stream<CategoryConfiguration<?>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public <T extends Display> void add(DisplayCategory<T> category) {
        this.add(category, (CategoryConfiguration<T> config) -> {});
    }

    public <T extends Display> void add(DisplayCategory<T> var1, Consumer<CategoryConfiguration<T>> var2);

    default public <T extends Display> void add(Iterable<DisplayCategory<? extends T>> categories) {
        for (DisplayCategory<T> displayCategory : categories) {
            this.add(displayCategory);
        }
    }

    default public <T extends Display> void add(DisplayCategory<? extends T> ... categories) {
        for (DisplayCategory<? extends T> category : categories) {
            this.add((DisplayCategory<T>)category);
        }
    }

    public <T extends Display> CategoryConfiguration<T> get(CategoryIdentifier<T> var1);

    public <T extends Display> Optional<CategoryConfiguration<T>> tryGet(CategoryIdentifier<T> var1);

    public <T extends Display> void configure(CategoryIdentifier<T> var1, Consumer<CategoryConfiguration<T>> var2);

    public int size();

    public void registerVisibilityPredicate(CategoryVisibilityPredicate var1);

    public boolean isCategoryVisible(DisplayCategory<?> var1);

    default public boolean isCategoryInvisible(DisplayCategory<?> category) {
        return !this.isCategoryVisible(category);
    }

    public List<CategoryVisibilityPredicate> getVisibilityPredicates();

    default public <D extends Display> void addWorkstations(CategoryIdentifier<D> category, EntryIngredient ... stations) {
        this.configure(category, config -> config.addWorkstations(stations));
    }

    default public <D extends Display> void addWorkstations(CategoryIdentifier<D> category, EntryStack<?> ... stations) {
        this.configure(category, config -> config.addWorkstations(stations));
    }

    @Deprecated(forRemoval=true)
    default public <D extends Display> void removePlusButton(CategoryIdentifier<D> category) {
        this.configure(category, CategoryConfiguration::removePlusButton);
    }

    default public <D extends Display> void setPlusButtonArea(CategoryIdentifier<D> category, ButtonArea area) {
        this.configure(category, config -> config.setPlusButtonArea(area));
    }

    public static interface CategoryConfiguration<T extends Display>
    extends Identifiable {
        public void addWorkstations(EntryIngredient ... var1);

        default public void addWorkstations(EntryStack<?> ... stations) {
            this.addWorkstations(CollectionUtils.map(stations, EntryIngredient::of).toArray(new EntryIngredient[0]));
        }

        @Deprecated(forRemoval=true)
        default public void removePlusButton() {
            this.setPlusButtonArea(bounds -> null);
        }

        public void setPlusButtonArea(ButtonArea var1);

        @ApiStatus.Experimental
        public boolean isQuickCraftingEnabledByDefault();

        @ApiStatus.Experimental
        public void setQuickCraftingEnabledByDefault(boolean var1);

        public Optional<ButtonArea> getPlusButtonArea();

        public List<EntryIngredient> getWorkstations();

        public DisplayCategory<T> getCategory();

        public CategoryIdentifier<?> getCategoryIdentifier();

        @ApiStatus.Experimental
        public void registerExtension(CategoryExtensionProvider<T> var1);

        @ApiStatus.Experimental
        public DisplayCategoryView<T> getView(T var1);

        @Override
        default public ResourceLocation getIdentifier() {
            return this.getCategoryIdentifier().getIdentifier();
        }
    }
}

