/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.core;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;

public abstract class CompositeHolderSet<T>
extends HolderSet.ListBacked<T> {
    protected final List<HolderSet<T>> components;

    public CompositeHolderSet(List<HolderSet<T>> components) {
        this.components = components;
    }

    public Either<TagKey<T>, List<Holder<T>>> unwrap() {
        return Either.right((Object)this.contents());
    }

    public Optional<TagKey<T>> unwrapKey() {
        return Optional.empty();
    }

    public boolean canSerializeIn(HolderOwner<T> owner) {
        for (HolderSet<T> holderSet : this.components) {
            if (holderSet.canSerializeIn(owner)) continue;
            return false;
        }
        return super.canSerializeIn(owner);
    }

    public static class Removal<T>
    extends CompositeHolderSet<T> {
        private final HolderSet<T> holderSet;
        private final HolderSet<T> removals;

        public Removal(HolderSet<T> holderSet, HolderSet<T> removals) {
            super(List.of(holderSet, removals));
            this.holderSet = holderSet;
            this.removals = removals;
        }

        protected List<Holder<T>> contents() {
            return this.holderSet.stream().filter(Predicate.not(arg_0 -> this.removals.contains(arg_0))).toList();
        }

        public boolean contains(Holder<T> holder) {
            return this.holderSet.contains(holder) && !this.removals.contains(holder);
        }

        public String toString() {
            return "RemovalSet[" + String.valueOf(this.contents()) + "]";
        }
    }

    public static class And<T>
    extends CompositeHolderSet<T> {
        public And(List<HolderSet<T>> components) {
            super(components);
        }

        protected List<Holder<T>> contents() {
            return this.components.stream().map(holderSet -> holderSet.stream().collect(Collectors.toSet())).reduce(Sets::intersection).map(List::copyOf).orElseGet(List::of);
        }

        public boolean contains(Holder<T> holder) {
            for (HolderSet holderSet : this.components) {
                if (holderSet.contains(holder)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "AndSet[" + String.valueOf(this.contents()) + "]";
        }
    }

    public static class Or<T>
    extends CompositeHolderSet<T> {
        public Or(List<HolderSet<T>> components) {
            super(components);
        }

        protected List<Holder<T>> contents() {
            return this.components.stream().flatMap(HolderSet::stream).distinct().toList();
        }

        public boolean contains(Holder<T> holder) {
            for (HolderSet holderSet : this.components) {
                if (!holderSet.contains(holder)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "OrSet[" + String.valueOf(this.contents()) + "]";
        }
    }
}

