/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs.neoforge;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigSpec;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.mehvahdjukaar.modelfix.moonlight_configs.neoforge.ConfigBuilderImpl;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ConfigSpecWrapper
extends ConfigSpec {
    private static final Method LOAD_CONFIG = ObfuscationReflectionHelper.findMethod(ConfigTracker.class, (String)"loadConfig", (Class[])new Class[]{ModConfig.class, Path.class, Function.class});
    private final ModConfigSpec spec;
    private final ModConfig modConfig;
    private final Map<ModConfigSpec.ConfigValue<?>, Object> requireRestartValues;
    private final List<ConfigBuilderImpl.ValueWrapper<?, ?>> specialValues;

    public ConfigSpecWrapper(ResourceLocation name, ModConfigSpec spec, ConfigType type, @Nullable Runnable onChange, List<ModConfigSpec.ConfigValue<?>> requireRestart, List<ConfigBuilderImpl.ValueWrapper<?, ?>> specialValues) {
        super(name, "toml", FMLPaths.CONFIGDIR.get(), type, onChange);
        this.spec = spec;
        this.specialValues = specialValues;
        ModConfig.Type forgeType = this.getConfigType() == ConfigType.CLIENT ? ModConfig.Type.CLIENT : ModConfig.Type.COMMON;
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        this.modConfig = ConfigTracker.INSTANCE.registerConfig(forgeType, (IConfigSpec)spec, modContainer, this.getFileName());
        IEventBus bus = modContainer.getEventBus();
        if (onChange != null || this.isSynced() || !specialValues.isEmpty()) {
            bus.addListener(this::onConfigChange);
        }
        if (!requireRestart.isEmpty()) {
            this.forceLoad();
        }
        this.requireRestartValues = requireRestart.stream().collect(Collectors.toMap(e -> e, ModConfigSpec.ConfigValue::get));
    }

    @Override
    public Path getFullPath() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getFileName());
    }

    @Override
    public void forceLoad() {
        if (this.isLoaded()) {
            return;
        }
        try {
            LOAD_CONFIG.invoke((Object)ConfigTracker.INSTANCE, this.modConfig, this.getFullPath(), ModConfigEvent.Loading::new);
        }
        catch (Exception e) {
            throw new ConfigSpec.ConfigLoadingException(this, e);
        }
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Nullable
    public ModConfig getModConfig() {
        return this.modConfig;
    }

    @Override
    public boolean isLoaded() {
        return this.spec.isLoaded();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen makeScreen(Screen parent, @Nullable ResourceLocation background) {
        return ModList.get().getModContainerById(this.getModId()).flatMap(container -> container.getCustomExtension(IConfigScreenFactory.class).map(factory -> factory.createScreen(container, parent))).orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasConfigScreen() {
        return ModList.get().getModContainerById(this.getModId()).map(container -> container.getCustomExtension(IConfigScreenFactory.class).isPresent()).orElse(false);
    }

    @ApiStatus.Internal
    public void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == this.getSpec()) {
            this.onRefresh();
            this.specialValues.forEach(ConfigBuilderImpl.ValueWrapper::clearCache);
        }
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        try {
            byte[] b = stream.readAllBytes();
            ConfigTracker.acceptSyncedConfig((ModConfig)this.modConfig, (byte[])b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean requiresGameRestart(ModConfigSpec.ConfigValue<?> value) {
        Object v = this.requireRestartValues.get(value);
        if (v == null) {
            return false;
        }
        return v != value.get();
    }
}

