/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.worldgen.slabfeature;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.ModSlabsMap;
import net.countered.terrainslabs.config.MyModConfig;
import net.countered.terrainslabs.persistence.SlabChunkAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SlabFeatureLogic
extends Feature<NoneFeatureConfiguration> {
    public static final Set<Block> SOIL_SLAB_BLOCKS = Set.of(ModBlocksRegistry.GRASS_SLAB, ModBlocksRegistry.PODZOL_SLAB, ModBlocksRegistry.MYCELIUM_SLAB, ModBlocksRegistry.PATH_SLAB);

    public SlabFeatureLogic(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (MyModConfig.enableSlabGeneration) {
            this.storeSlabPositions(context);
            return true;
        }
        return false;
    }

    private void storeSlabPositions(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldAccess = context.level();
        BlockPos origin = context.origin();
        ChunkPos chunkPos = new ChunkPos(origin);
        ChunkAccess chunk = worldAccess.getChunk(chunkPos.x, chunkPos.z);
        BlockPos highestBlock = this.findHighestChunkPos((LevelAccessor)worldAccess, chunkPos);
        for (int y = worldAccess.getMinBuildHeight(); y < highestBlock.getY() + 1; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockState currentBlockState;
                    BlockPos currentPos = chunkPos.getBlockAt(x, y, z);
                    BlockPos blockBelowPos = currentPos.below();
                    BlockPos blockAbovePos = currentPos.above();
                    BlockState blockBelowState = worldAccess.getBlockState(blockBelowPos);
                    BlockState blockAboveState = worldAccess.getBlockState(blockAbovePos);
                    if (this.shouldPlaceBottomSlab((LevelAccessor)worldAccess, currentPos, blockAboveState, blockBelowState, currentBlockState = worldAccess.getBlockState(currentPos))) {
                        ((List)chunk.getAttachedOrCreate(SlabChunkAttachment.BOT_SLAB_POSITIONS)).add(currentPos);
                        continue;
                    }
                    if (!this.shouldPlaceTopSlab((LevelAccessor)worldAccess, currentPos, currentBlockState, blockBelowState, blockAboveState, blockAbovePos)) continue;
                    ((List)chunk.getAttachedOrCreate(SlabChunkAttachment.TOP_SLAB_POSITIONS)).add(currentPos);
                }
            }
        }
    }

    private BlockPos findHighestChunkPos(LevelAccessor worldAccess, ChunkPos chunkPos) {
        BlockPos.MutableBlockPos highestChunkPos = new BlockPos.MutableBlockPos(0, 0, 0);
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = chunkPos.getMinBlockX(); x <= chunkPos.getMaxBlockX(); ++x) {
            for (int z = chunkPos.getMinBlockZ(); z <= chunkPos.getMaxBlockZ(); ++z) {
                testPos.set(x, 0, z);
                BlockPos topPosition = worldAccess.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, (BlockPos)testPos);
                if (highestChunkPos.getY() >= topPosition.getY()) continue;
                highestChunkPos = topPosition.mutable();
            }
        }
        return highestChunkPos;
    }

    private boolean shouldPlaceBottomSlab(LevelAccessor world, BlockPos currentPos, BlockState blockAboveState, BlockState blockBelowState, BlockState currentBlockState) {
        if (currentBlockState.isSolidRender((BlockGetter)world, currentPos) && !currentBlockState.is(Blocks.SNOW) && !currentBlockState.canBeReplaced() || ModSlabsMap.getSlabForBlock(blockBelowState.getBlock()) == Blocks.AIR || !blockAboveState.is(Blocks.AIR) && !blockAboveState.is(Blocks.WATER) && !blockAboveState.is(Blocks.CAVE_AIR) && !blockAboveState.is(Blocks.VOID_AIR)) {
            return false;
        }
        return this.validSurroundingBottom(world, currentPos);
    }

    private boolean shouldPlaceTopSlab(LevelAccessor world, BlockPos currentPos, BlockState currentState, BlockState blockBelow, BlockState blockAboveState, BlockPos blockAbovePos) {
        if (!currentState.isSolidRender((BlockGetter)world, currentPos) || !blockBelow.is(Blocks.AIR) && !blockBelow.is(Blocks.WATER) && !blockBelow.is(Blocks.CAVE_AIR) && !blockBelow.is(Blocks.VOID_AIR) || ModSlabsMap.getSlabForBlock(blockAboveState.getBlock()).equals(Blocks.AIR)) {
            return false;
        }
        return this.validSurroundingTop(world, currentPos);
    }

    private boolean validSurroundingTop(LevelAccessor world, BlockPos currentPos) {
        boolean topOfCeiling = false;
        boolean validNeighbors = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean isBelowOppositeStateNotOpaque;
            BlockPos neighborPos = currentPos.relative(direction);
            BlockPos aboveNeighborPos = neighborPos.above();
            BlockPos oppositePos = currentPos.relative(direction.getOpposite());
            BlockPos belowOppositePos = oppositePos.below();
            BlockState neighborState = world.getBlockState(neighborPos);
            BlockState aboveNeighborState = world.getBlockState(aboveNeighborPos);
            BlockState oppositeState = world.getBlockState(oppositePos);
            BlockState belowOppositeState = world.getBlockState(belowOppositePos);
            if (neighborState.is(Blocks.GLOW_LICHEN) || neighborState.is(Blocks.LAVA)) {
                return false;
            }
            boolean isNeighborStateNotOpaque = !neighborState.isSolidRender((BlockGetter)world, neighborPos);
            boolean isOppositeStateOpaque = oppositeState.isSolidRender((BlockGetter)world, oppositePos);
            boolean isAboveNeighborStateOpaque = aboveNeighborState.isSolidRender((BlockGetter)world, aboveNeighborPos);
            boolean bl = isBelowOppositeStateNotOpaque = !belowOppositeState.isSolidRender((BlockGetter)world, belowOppositePos);
            if (isNeighborStateNotOpaque && isOppositeStateOpaque && isBelowOppositeStateNotOpaque) {
                topOfCeiling = true;
            }
            if (!neighborState.is(Blocks.AIR) && !neighborState.is(Blocks.WATER) && !neighborState.is(Blocks.CAVE_AIR) && !neighborState.is(Blocks.VOID_AIR)) continue;
            validNeighbors = true;
        }
        return topOfCeiling && validNeighbors;
    }

    private boolean validSurroundingBottom(LevelAccessor world, BlockPos currentPos) {
        boolean bottomOfMountain = false;
        boolean validNeighbors = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean isOppositeDirNoSnow;
            BlockPos neighborPos = currentPos.relative(direction);
            BlockPos belowNeighborPos = neighborPos.below();
            BlockPos oppositePos = currentPos.relative(direction.getOpposite());
            BlockState neighborState = world.getBlockState(neighborPos);
            BlockState belowNeighborState = world.getBlockState(belowNeighborPos);
            BlockState oppositeState = world.getBlockState(oppositePos);
            if (neighborState.is(Blocks.LAVA)) {
                return false;
            }
            boolean isNeighborBelowOpaque = belowNeighborState.canOcclude();
            boolean isOppositeDirOpaque = oppositeState.canOcclude();
            boolean isBelowNoSlab = !(belowNeighborState.getBlock() instanceof SlabBlock);
            boolean isOppositeDirNoSlab = !(oppositeState.getBlock() instanceof SlabBlock);
            boolean isNeighborBelowNoSnow = !belowNeighborState.is(Blocks.SNOW) && !belowNeighborState.is(ModBlocksRegistry.SNOW_ON_TOP);
            boolean bl = isOppositeDirNoSnow = !oppositeState.is(Blocks.SNOW) && !oppositeState.is(ModBlocksRegistry.SNOW_ON_TOP);
            if (isNeighborBelowOpaque && isOppositeDirOpaque && isBelowNoSlab && isOppositeDirNoSlab && isNeighborBelowNoSnow && isOppositeDirNoSnow) {
                bottomOfMountain = true;
            }
            if (!neighborState.isSolidRender((BlockGetter)world, neighborPos) || neighborState.getBlock() instanceof SlabBlock || neighborState.is(Blocks.SNOW) || world.getBlockState(neighborPos.above()).canOcclude() && world.getBlockState(neighborPos.above()).getBlock() != Blocks.SNOW) continue;
            validNeighbors = true;
        }
        return validNeighbors && bottomOfMountain;
    }
}

