/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.block.customslabs.specialslabs;

import com.mojang.serialization.MapCodec;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class GravityAffectedSlab
extends CustomSlab
implements Fallable {
    public static final MapCodec<GravityAffectedSlab> CODEC = GravityAffectedSlab.simpleCodec(GravityAffectedSlab::new);

    public GravityAffectedSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED, GENERATED});
    }

    public MapCodec<GravityAffectedSlab> codec() {
        return CODEC;
    }

    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.scheduleTick(pos, (Block)this, this.getFallDelay());
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        world.scheduleTick(pos, (Block)this, this.getFallDelay());
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (GravityAffectedSlab.canFallThrough(world.getBlockState(pos.below())) && pos.getY() >= world.getMinBuildHeight()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
            this.configureFallingBlockEntity(fallingBlockEntity);
        }
    }

    protected void configureFallingBlockEntity(FallingBlockEntity entity) {
    }

    protected int getFallDelay() {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        return state.isAir() || state.is(BlockTags.FIRE) || state.liquid() || state.canBeReplaced();
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        if (random.nextInt(16) == 0 && GravityAffectedSlab.canFallThrough(world.getBlockState(blockPos = pos.below()))) {
            ParticleUtils.spawnParticleBelow((Level)world, (BlockPos)pos, (RandomSource)random, (ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state));
        }
    }

    public int getColor(BlockState state, BlockGetter world, BlockPos pos) {
        return -16777216;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        BlockState blockState = ctx.getLevel().getBlockState(blockPos);
        if (blockState.is((Block)this)) {
            return (BlockState)((BlockState)blockState.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidState = ctx.getLevel().getFluidState(blockPos);
        BlockState blockState2 = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        Direction direction = ctx.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && ctx.getClickLocation().y - (double)blockPos.getY() > 0.5) ? blockState2 : (BlockState)blockState2.setValue((Property)TYPE, (Comparable)SlabType.BOTTOM);
    }

    public void onBrokenAfterFall(Level world, BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        super.onBrokenAfterFall(world, pos, fallingBlockEntity);
        if (fallingBlockEntity.getBlockState().getValue((Property)TYPE) == SlabType.DOUBLE) {
            GravityAffectedSlab.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem()));
        }
    }

    public void onLand(Level world, BlockPos pos, BlockState fallingBlockState, BlockState currentStateInPos, FallingBlockEntity fallingBlockEntity) {
        super.onLand(world, pos, fallingBlockState, currentStateInPos, fallingBlockEntity);
        if (fallingBlockState.getValue((Property)TYPE) == SlabType.TOP) {
            world.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM));
        }
    }
}

