/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.spout;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.cotrin8672.cem.client.CustomRenderType;
import io.github.cotrin8672.cem.config.CemConfig;
import io.github.cotrin8672.cem.content.block.spout.EnchantableSpoutBlockEntity;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import io.github.cotrin8672.cem.util.PoseStackExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/cotrin8672/cem/content/block/spout/EnchantableSpoutRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SafeBlockEntityRenderer;", "Lio/github/cotrin8672/cem/content/block/spout/EnchantableSpoutBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "renderSafe", "", "be", "partialTicks", "", "ms", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "Companion", "createenchantablemachinery"})
public final class EnchantableSpoutRenderer
extends SafeBlockEntityRenderer<EnchantableSpoutBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    private static final RandomSource RANDOM = RandomSource.create();
    @NotNull
    private static final PartialModel[] BITS;

    public EnchantableSpoutRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    protected void renderSafe(@NotNull EnchantableSpoutBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(buffer.getBuffer(CustomRenderType.Companion.getGLINT()), ms.last(), 0.007125f);
            this.context.getBlockRenderDispatcher().renderBatched(be.getBlockState(), be.getBlockPos(), (BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be), ms, (VertexConsumer)consumer, true, RANDOM, ModelData.EMPTY, null);
        }
        SmartFluidTankBehaviour tank = be.getFluidTank();
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = tank.getPrimaryTank().getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        int processingTicks = be.processingTicks;
        float processingPT = (float)processingTicks - partialTicks;
        float processingProgress = 1.0f - (processingPT - (float)be.getExecutionTick()) / (float)(be.getEnchantedFillingTime() - be.getExecutionTick());
        processingProgress = Mth.clamp((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = 0.0f;
        if (!fluidStack.isEmpty() && processingTicks != -1) {
            radius = (float)(Math.pow((float)2 * processingProgress - 1.0f, 2.0) - 1.0);
            AABB bb = new AABB(0.5, 0.5, 0.5, 0.5, -1.2, 0.5).inflate((double)(radius / 32.0f));
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, (float)bb.minX, (float)bb.minY, (float)bb.minZ, (float)bb.maxX, (float)bb.maxY, (float)bb.maxZ, buffer, ms, light, false, true);
        }
        float squeeze = processingPT < 0.0f ? 0.0f : (processingPT < 2.0f ? Mth.lerp((float)(processingPT / 2.0f), (float)0.0f, (float)-1.0f) : (processingPT < (float)(be.getEnchantedFillingTime() - be.getExecutionTick()) ? -1.0f : radius));
        PoseStackExtensionKt.use(ms, arg_0 -> EnchantableSpoutRenderer.renderSafe$lambda$0(be, light, ms, buffer, squeeze, arg_0));
        if (!fluidStack.isEmpty() && !(level == 0.0f)) {
            boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
            level = Math.max(level, 0.175f);
            float min = 0.15625f;
            float max = min + 0.6875f;
            float yOffset = 0.6875f * level;
            PoseStackExtensionKt.use(ms, arg_0 -> EnchantableSpoutRenderer.renderSafe$lambda$1(top, ms, yOffset, max, min, fluidStack, buffer, light, arg_0));
        }
    }

    private static final Unit renderSafe$lambda$0(EnchantableSpoutBlockEntity $be, int $light, PoseStack $ms, MultiBufferSource $buffer, float $squeeze, PoseStack $this$use) {
        Intrinsics.checkNotNullParameter((Object)$this$use, (String)"$this$use");
        for (PartialModel bit : BITS) {
            CachedBuffers.partial((PartialModel)bit, (BlockState)$be.getBlockState()).light($light).renderInto($ms, $buffer.getBuffer(RenderType.solid()));
            if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
                SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator($buffer.getBuffer(CustomRenderType.Companion.getGLINT()), $ms.last(), 0.007125f);
                CachedBuffers.partial((PartialModel)bit, (BlockState)$be.getBlockState()).light($light).renderInto($ms, (VertexConsumer)consumer);
            }
            $ms.translate(0.0f, (float)-3 * $squeeze / 32.0f, 0.0f);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderSafe$lambda$1(boolean $top, PoseStack $ms, float $yOffset, float $max, float $min, FluidStack $fluidStack, MultiBufferSource $buffer, int $light, PoseStack $this$use) {
        Intrinsics.checkNotNullParameter((Object)$this$use, (String)"$this$use");
        if (!$top) {
            $ms.translate(0.0f, $yOffset, 0.0f);
        } else {
            $ms.translate(0.0f, $max - $min, 0.0f);
        }
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)$fluidStack, $min, $min - $yOffset, $min, $max, $min, $max, $buffer, $ms, $light, false, true);
        return Unit.INSTANCE;
    }

    static {
        PartialModel[] partialModelArray = new PartialModel[]{AllPartialModels.SPOUT_TOP, AllPartialModels.SPOUT_MIDDLE, AllPartialModels.SPOUT_BOTTOM};
        BITS = partialModelArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/github/cotrin8672/cem/content/block/spout/EnchantableSpoutRenderer$Companion;", "", "<init>", "()V", "RANDOM", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/RandomSource;", "BITS", "", "Ldev/engine_room/flywheel/lib/model/baked/PartialModel;", "[Ldev/engine_room/flywheel/lib/model/baked/PartialModel;", "createenchantablemachinery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

