/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.mixer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.cotrin8672.cem.client.CustomRenderType;
import io.github.cotrin8672.cem.config.CemConfig;
import io.github.cotrin8672.cem.content.block.mixer.EnchantableMechanicalMixerBlockEntity;
import io.github.cotrin8672.cem.registry.PartialModelRegistration;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.forge.PoseStackUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/cotrin8672/cem/content/block/mixer/EnchantableMechanicalMixerRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lio/github/cotrin8672/cem/content/block/mixer/EnchantableMechanicalMixerBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "shouldRenderOffScreen", "", "be", "renderSafe", "", "partialTicks", "", "ms", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "Companion", "createenchantablemachinery"})
public final class EnchantableMechanicalMixerRenderer
extends KineticBlockEntityRenderer<EnchantableMechanicalMixerBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    private static final RandomSource RANDOM = RandomSource.create();

    public EnchantableMechanicalMixerRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
    }

    public boolean shouldRenderOffScreen(@NotNull EnchantableMechanicalMixerBlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        return true;
    }

    protected void renderSafe(@NotNull EnchantableMechanicalMixerBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BlockState blockState = be.getBlockState();
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL, (BlockState)blockState);
        double renderedHeadOffset = be.getRenderedHeadOffset(partialTicks);
        float speed = be.getRenderedHeadRotationSpeed(partialTicks);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)((LevelAccessor)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be)));
        double angle = (double)(time * speed * (float)6 / 10.0f % (float)360 / (float)180) * Math.PI;
        SuperByteBuffer poleRender = CachedBuffers.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE, (BlockState)blockState);
        if (!VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)be.getLevel()))) {
            KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)((KineticBlockEntity)be), (int)light).renderInto(ms, vb);
            ((SuperByteBuffer)poleRender.translate(0.0, -renderedHeadOffset, 0.0)).light(light).renderInto(ms, vb);
            VertexConsumer vbCutout = buffer.getBuffer(RenderType.cutoutMipped());
            SuperByteBuffer headRender = CachedBuffers.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_HEAD, (BlockState)blockState);
            ((SuperByteBuffer)((SuperByteBuffer)headRender.rotateCentered((float)angle, Direction.UP)).translate(0.0, -renderedHeadOffset, 0.0)).light(light).renderInto(ms, vbCutout);
        }
        PoseStackUtilKt.use((PoseStack)ms, () -> EnchantableMechanicalMixerRenderer.renderSafe$lambda$0(buffer, ms, this, be, blockState, angle, renderedHeadOffset, light, superBuffer, poleRender));
    }

    private static final Unit renderSafe$lambda$0(MultiBufferSource $buffer, PoseStack $ms, EnchantableMechanicalMixerRenderer this$0, EnchantableMechanicalMixerBlockEntity $be, BlockState $blockState, double $angle, double $renderedHeadOffset, int $light, SuperByteBuffer $superBuffer, SuperByteBuffer $poleRender) {
        if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator($buffer.getBuffer(CustomRenderType.Companion.getGLINT()), $ms.last(), 0.007125f);
            this$0.context.getBlockRenderDispatcher().renderBatched($be.getBlockState(), $be.getBlockPos(), (BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)$be), $ms, (VertexConsumer)consumer, true, RANDOM);
            SuperByteBuffer enchantableHead = CachedBuffers.partial((PartialModel)PartialModelRegistration.getENCHANTABLE_MECHANICAL_MIXER_HEAD(), (BlockState)$blockState);
            ((SuperByteBuffer)((SuperByteBuffer)enchantableHead.rotateCentered((float)$angle, Direction.UP)).translate(0.0, -$renderedHeadOffset, 0.0)).light($light).renderInto($ms, (VertexConsumer)consumer);
            if (!VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)$be.getLevel()))) {
                KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)$superBuffer, (KineticBlockEntity)((KineticBlockEntity)$be), (int)$light).renderInto($ms, (VertexConsumer)consumer);
                ((SuperByteBuffer)$poleRender.translate(0.0, -$renderedHeadOffset, 0.0)).light($light).renderInto($ms, (VertexConsumer)consumer);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/cotrin8672/cem/content/block/mixer/EnchantableMechanicalMixerRenderer$Companion;", "", "<init>", "()V", "RANDOM", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/RandomSource;", "createenchantablemachinery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

