/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawningshulkers.neoforge.events;

import com.natamus.respawningshulkers_common_neoforge.events.ShulkerEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class NeoForgeShulkerEvent {
    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Pre e) {
        Level level = e.getLevel();
        if (level.isClientSide) {
            return;
        }
        ShulkerEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onShulkerDeath(LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        ShulkerEvent.onShulkerDeath(entity.level(), (Entity)entity, e.getSource());
    }

    @SubscribeEvent
    public static void onServerShutdown(ServerStoppingEvent e) {
        ShulkerEvent.onServerShutdown(e.getServer());
    }
}

