/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.client.gui.StorageGuiGraphics;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotDrawer;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotStorage;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DrawerScreen
extends AbstractContainerScreen<ContainerDrawers> {
    private static final ResourceLocation guiTextures1 = ModConstants.loc("textures/gui/drawers_1.png");
    private static final ResourceLocation guiTextures2 = ModConstants.loc("textures/gui/drawers_2.png");
    private static final ResourceLocation guiTextures4 = ModConstants.loc("textures/gui/drawers_4.png");
    private static final ResourceLocation guiTexturesComp2 = ModConstants.loc("textures/gui/drawers_comp_2.png");
    private static final ResourceLocation guiTexturesComp3 = ModConstants.loc("textures/gui/drawers_comp.png");
    private static final int smDisabledX = 176;
    private static final int smDisabledY = 0;
    private static final int smMissingY = 16;
    private static StorageGuiGraphics storageGuiGraphics;
    private final ResourceLocation background;
    private final Inventory inventory;

    public DrawerScreen(ContainerDrawers container, Inventory playerInv, Component name, ResourceLocation bg) {
        super((AbstractContainerMenu)container, playerInv, name);
        this.imageWidth = 176;
        this.imageHeight = 199;
        this.background = bg;
        this.inventory = playerInv;
    }

    protected void init() {
        super.init();
        if (storageGuiGraphics == null && this.minecraft != null) {
            storageGuiGraphics = new StorageGuiGraphics(this.minecraft, this.minecraft.renderBuffers().bufferSource());
        }
    }

    public void render(GuiGraphics graphics, int x, int y, float f) {
        ((ContainerDrawers)this.menu).activeGuiGraphics = storageGuiGraphics;
        super.render((GuiGraphics)storageGuiGraphics, x, y, f);
        ((ContainerDrawers)this.menu).activeGuiGraphics = null;
        DrawerScreen.storageGuiGraphics.overrideStack = ItemStack.EMPTY;
        this.renderTooltip(graphics, x, y);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        graphics.drawString(this.font, I18n.get((String)"container.storagedrawers.upgrades", (Object[])new Object[0]), 8, 75, 0x404040, false);
        graphics.drawString(this.font, this.inventory.getDisplayName().getString(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        String mult = Integer.toString(((ContainerDrawers)this.menu).getStackCapacity());
        graphics.drawString(this.font, mult, 161 - mult.length() * 6, 42, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        graphics.blit(this.background, guiX, guiY, 0, 0, this.imageWidth, this.imageHeight);
        List<Slot> storageSlots = ((ContainerDrawers)this.menu).getStorageSlots();
        for (Slot slot : storageSlots) {
            SlotDrawer sd;
            if (slot instanceof SlotDrawer && (sd = (SlotDrawer)slot).getDrawer().isMissing()) {
                graphics.blit(this.background, guiX + slot.x, guiY + slot.y, 176, 16, 16, 16);
                continue;
            }
            graphics.blit(this.background, guiX + slot.x, guiY + slot.y, 176, 0, 16, 16);
        }
        List<Slot> upgradeSlots = ((ContainerDrawers)this.menu).getUpgradeSlots();
        for (Slot slot : upgradeSlots) {
            boolean locked = false;
            Container container = slot.container;
            if (container instanceof InventoryUpgrade) {
                InventoryUpgrade ucontainer = (InventoryUpgrade)container;
                locked = ucontainer.slotIsLocked(slot.getContainerSlot());
            }
            if (!locked) continue;
            graphics.blit(this.background, guiX + slot.x, guiY + slot.y, 176, 0, 16, 16);
        }
    }

    protected boolean isHovering(int x, int y, int width, int height, double originX, double originY) {
        List<Slot> storageSlots = ((ContainerDrawers)this.menu).getStorageSlots();
        for (Slot slot : storageSlots) {
            if (!(slot instanceof SlotStorage) || slot.x != x || slot.y != y) continue;
            return false;
        }
        return super.isHovering(x, y, width, height, originX, originY);
    }

    public static class Compacting3
    extends DrawerScreen {
        public Compacting3(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTexturesComp3);
        }
    }

    public static class Compacting2
    extends DrawerScreen {
        public Compacting2(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTexturesComp2);
        }
    }

    public static class Slot4
    extends DrawerScreen {
        public Slot4(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures4);
        }
    }

    public static class Slot2
    extends DrawerScreen {
        public Slot2(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures2);
        }
    }

    public static class Slot1
    extends DrawerScreen {
        public Slot1(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures1);
        }
    }
}

