/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DetachedDrawerData
implements IDrawer {
    private ItemStack protoStack;
    private int count;
    private int storageMult;
    private boolean heavy;

    public DetachedDrawerData() {
        this.protoStack = ItemStack.EMPTY;
        this.count = 0;
        this.storageMult = 1;
        this.heavy = false;
    }

    public DetachedDrawerData(IDrawer sourceDrawer) {
        this(sourceDrawer, 1);
    }

    public DetachedDrawerData(IDrawer sourceDrawer, int storageMult) {
        this.protoStack = sourceDrawer.getStoredItemPrototype();
        this.count = sourceDrawer.getStoredItemCount();
        this.storageMult = storageMult;
    }

    public DetachedDrawerData(HolderLookup.Provider provider, CompoundTag serializedTag) {
        this.deserializeNBT(provider, serializedTag);
    }

    protected DetachedDrawerData(DetachedDrawerData data) {
        this.protoStack = data.protoStack;
        this.count = data.count;
        this.storageMult = data.storageMult;
        this.heavy = data.heavy;
    }

    public int getStorageMultiplier() {
        return this.storageMult;
    }

    public void setStorageMultiplier(int storageMult) {
        this.storageMult = storageMult;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public void setIsHeavy(boolean state) {
        this.heavy = state;
    }

    @Override
    @NotNull
    public ItemStack getStoredItemPrototype() {
        return this.protoStack;
    }

    @Override
    @NotNull
    public IDrawer setStoredItem(@NotNull ItemStack itemPrototype) {
        return this;
    }

    protected IDrawer setStoredItemRaw(@NotNull ItemStack itemPrototype) {
        this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
        this.protoStack.setCount(1);
        this.count = 0;
        return this;
    }

    @Override
    public int getStoredItemCount() {
        return this.count;
    }

    @Override
    public void setStoredItemCount(int amount) {
    }

    protected void setStoredItemCountRaw(int amount) {
        this.count = amount;
    }

    @Override
    public int getMaxCapacity(@NotNull ItemStack itemPrototype) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getRemainingCapacity() {
        return this.getMaxCapacity() - this.getStoredItemCount();
    }

    @Override
    public boolean canItemBeStored(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
        return false;
    }

    @Override
    public boolean canItemBeExtracted(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.protoStack.isEmpty();
    }

    @Override
    public IDrawer copy() {
        return new DetachedDrawerData(this);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.storageMult > 1) {
            tag.putInt("StorageMult", this.storageMult);
        }
        if (this.protoStack.isEmpty()) {
            return tag;
        }
        CompoundTag item = new CompoundTag();
        item = (CompoundTag)this.protoStack.save(provider, (Tag)item);
        tag.put("Item", (Tag)item);
        tag.putInt("Count", this.count);
        if (this.heavy) {
            tag.putBoolean("Heavy", true);
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ItemStack tagItem = ItemStack.EMPTY;
        int tagCount = 0;
        if (nbt == null) {
            return;
        }
        if (nbt.contains("Item")) {
            tagItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("Item"));
        }
        if (nbt.contains("Count")) {
            tagCount = nbt.getInt("Count");
        }
        this.storageMult = nbt.contains("StorageMult") ? nbt.getInt("StorageMult") : (Integer)ModCommonConfig.INSTANCE.GENERAL.baseStackStorage.get() * 8;
        if (nbt.contains("Heavy")) {
            this.setIsHeavy(nbt.getBoolean("Heavy"));
        }
        this.setStoredItemRaw(tagItem);
        this.setStoredItemCountRaw(tagCount);
    }
}

