/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStandardDrawers
extends BlockDrawers
implements IFramedSourceBlock {
    public static final MapCodec<BlockStandardDrawers> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("drawerCount").forGetter(BlockDrawers::getDrawerCount), (App)Codec.BOOL.fieldOf("halfDepth").forGetter(BlockDrawers::isHalfDepth), (App)Codec.INT.fieldOf("storageUnits").forGetter(BlockDrawers::getStorageUnits), (App)BlockStandardDrawers.propertiesCodec()).apply((Applicative)instance, BlockStandardDrawers::new));
    private String matKey = null;
    private String matNamespace = "storagedrawers";

    public BlockStandardDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockStandardDrawers(int drawerCount, boolean halfDepth, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, BlockStandardDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 4 / drawerCount : 8 / drawerCount;
    }

    public BlockStandardDrawers setMatKey(ResourceLocation material) {
        this.matNamespace = material.getNamespace();
        this.matKey = material.getPath();
        return this;
    }

    public BlockStandardDrawers setMatKey(@Nullable String matKey) {
        this.matKey = matKey;
        return this;
    }

    public String getMatKey() {
        return this.matKey;
    }

    public String getNameMatKey() {
        return "block." + this.matNamespace + ".mat." + this.matKey;
    }

    public MapCodec<BlockStandardDrawers> codec() {
        return CODEC;
    }

    @Override
    protected int getFaceSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        if (!this.hitWithinArea(correctSide, normalizedHit, 0.0625f, 0.9375f)) {
            return super.getFaceSlot(correctSide, normalizedHit);
        }
        if (this.getDrawerCount() == 1) {
            return 0;
        }
        boolean hitTop = this.hitWithinY(normalizedHit, 0.5f, 1.0f);
        if (this.getDrawerCount() == 2) {
            return hitTop ? 0 : 1;
        }
        if (this.getDrawerCount() == 4) {
            if (this.hitWithinX(correctSide, normalizedHit, 0.0f, 0.5f)) {
                return hitTop ? 0 : 2;
            }
            return hitTop ? 1 : 3;
        }
        return super.getFaceSlot(correctSide, normalizedHit);
    }

    @Override
    public boolean retrimBlock(Level world, BlockPos pos, ItemStack prototype) {
        if (this.retrimType() == null) {
            return false;
        }
        Block protoBlock = Block.byItem((Item)prototype.getItem());
        if (!(protoBlock instanceof BlockTrim)) {
            return false;
        }
        BlockTrim trim = (BlockTrim)protoBlock;
        if (trim.getMatKey() == null || Objects.equals(trim.getMatKey(), "") || !trim.canUseForRetrim()) {
            return false;
        }
        List<BlockStandardDrawers> blockList = ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockStandardDrawers.class, this.getDrawerCount(), this.isHalfDepth()).filter(b -> b.getMatKey() == trim.getMatKey()).toList();
        if (blockList.size() != 1) {
            return false;
        }
        BlockStandardDrawers targetBlock = blockList.get(0);
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof BlockEntityDrawersStandard)) {
            return false;
        }
        BlockState curState = world.getBlockState(pos);
        BlockEntityDrawersStandard curEntity = (BlockEntityDrawersStandard)entity;
        CompoundTag entityData = curEntity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
        BlockState newState = (BlockState)targetBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)curState.getValue((Property)FACING)));
        world.setBlockAndUpdate(pos, newState);
        BlockEntity newEnt = world.getBlockEntity(pos);
        newEnt.loadCustomOnly(entityData, (HolderLookup.Provider)world.registryAccess());
        return true;
    }

    @Override
    public boolean repartitionBlock(Level world, BlockPos pos, ItemStack prototype) {
        if (this.retrimType() == null) {
            return false;
        }
        Block protoBlock = Block.byItem((Item)prototype.getItem());
        if (!(protoBlock instanceof BlockStandardDrawers)) {
            return false;
        }
        BlockStandardDrawers targetBlock = (BlockStandardDrawers)protoBlock;
        if (targetBlock.isHalfDepth() != this.isHalfDepth()) {
            return false;
        }
        if (targetBlock.getDrawerCount() == this.getDrawerCount()) {
            return false;
        }
        BlockEntity sourceEntity = world.getBlockEntity(pos);
        if (!(sourceEntity instanceof BlockEntityDrawersStandard)) {
            return false;
        }
        BlockEntityDrawersStandard sourceBE = (BlockEntityDrawersStandard)sourceEntity;
        ItemStack firstStack = sourceBE.getGroup().getDrawer(0).getStoredItemPrototype();
        int aggCount = 0;
        for (int i = 0; i < sourceBE.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = sourceBE.getGroup().getDrawer(i);
            ItemStack stack = drawer.getStoredItemPrototype();
            if (firstStack.isEmpty() && !stack.isEmpty()) {
                firstStack = stack;
            }
            if (!ItemStackMatcher.areItemsEqual(firstStack, stack) && !stack.isEmpty()) {
                return false;
            }
            aggCount += drawer.getStoredItemCount();
        }
        BlockState curState = world.getBlockState(pos);
        CompoundTag entityData = sourceEntity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
        BlockState newState = (BlockState)targetBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)curState.getValue((Property)FACING)));
        world.setBlockAndUpdate(pos, newState);
        BlockEntity newEnt = world.getBlockEntity(pos);
        newEnt.loadCustomOnly(entityData, (HolderLookup.Provider)world.registryAccess());
        BlockEntityDrawersStandard targetBE = (BlockEntityDrawersStandard)newEnt;
        int drawerCount = targetBE.getGroup().getDrawerCount();
        int divCount = aggCount / drawerCount;
        int remCount = aggCount - divCount * drawerCount;
        for (int i = 0; i < drawerCount; ++i) {
            int slotCount = divCount;
            if (i < remCount) {
                ++slotCount;
            }
            targetBE.getGroup().getDrawer(i).setStoredItem(firstStack, slotCount);
        }
        return true;
    }

    @Nullable
    public BlockEntityDrawers newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (BlockEntityDrawers)ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(this.getDrawerCount()).create(pos, state);
    }

    @Override
    public ItemStack makeFramedItem(ItemStack source, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        IFramedBlock frameBlock;
        switch (this.getDrawerCount()) {
            case 1: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_HALF_DRAWERS_1.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_FULL_DRAWERS_1.get();
                break;
            }
            case 2: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_HALF_DRAWERS_2.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_FULL_DRAWERS_2.get();
                break;
            }
            case 4: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_HALF_DRAWERS_4.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_FULL_DRAWERS_4.get();
                break;
            }
            default: {
                IFramedBlock iFramedBlock = frameBlock = null;
            }
        }
        if (frameBlock == null) {
            return ItemStack.EMPTY;
        }
        return FrameHelper.makeFramedItem(frameBlock, source, matSide, matTrim, matFront);
    }
}

